#pragma once
#include "mbed.h"

class CANInterface {
   public:
      enum BusSpeed {
         CAN_SPEED_125=125000,
         CAN_SPEED_250=250000,
         CAN_SPEED_500=500000
      };
   
      enum MessageType {
         CAN_PID_REQUEST=0x7DF,
         CAN_PID_REPLY=0x7E8
      };
   
      CANInterface(PinName rd, PinName td);
      ~CANInterface();
      int makeRequest(uint8_t pid,  uint8_t *outBuf, int *outLen);
      
   private:
      CAN *_can;
      Timer *_timer;
      int _timeout;
};