/* ATConsole.h */
/* Copyright (C) 2012 Ashley Mills, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#pragma once
#include "Console.h"
#include "VodafoneUSBModem.h"
/** Console for interacting with Vodafone USB (K3770/K3772-Z) dongles.
 */
class ATConsole : public Console, public IATCommandsProcessor, protected IATEventsHandler  {
    public:
    
        /** Constructor
         * @param terminal Console interface to the driving computer.
         * @param lineLength The maximum length of line supported (character console only).
         * @param numLines Number of lines of history to keep (character console only).
         * @param characterBased true if the driving console is character based, false if line based.
         * @param atInterface A Pointer to the ATInterface of the modem. 
         * @return An ATConsole
         */
        ATConsole(
           Serial *terminal,
           int lineLength,
           int numLines,
           bool characterBased,
           ATCommandsInterface* atInterface
        );
        ~ATConsole();
        virtual void update();
        
    private:  
        ATCommandsInterface *_atInterface;
        ATCommandsInterface::ATResult _cmdResult;
        virtual void processCommand();
        virtual int onNewATResponseLine(ATCommandsInterface* pInst, const char* line);
        virtual int onNewEntryPrompt(ATCommandsInterface* pInst);
        bool _gettingSMSData;
        char _smsMessage[256];
        
    protected:
        virtual void onEvent(const char* atCode, const char* evt);
        virtual void onDispatchStart();
        virtual void onDispatchStop();
        virtual bool isATCodeHandled(const char* atCode);
        virtual char* getEventsEnableCommand();
        virtual char* getEventsDisableCommand();
        
};