#include "mbed.h"
#include "rtos.h"
#include "ATConsole.h"
#include "VodafoneUSBModem.h"

DigitalOut myled(LED1);

int main() {
    DBG_INIT();
    DBG_SET_SPEED(115200);
    DBG_SET_NEWLINE("\r\n");

    // create serial
    Serial term(USBTX, USBRX);
    term.baud(115200);
    
    // create vodafone dongle interface
    VodafoneUSBModem modem;
    // force init
    size_t smCount;
    modem.getSMCount(&smCount);
    
    // create AT console
    int lineLength = 79;
    int numLines = 10;
    bool characterBased = true;
    ATConsole atCons(&term,lineLength,numLines,characterBased,modem.getATCommandsInterface());
    while(1) {
        atCons.update();
        Thread::wait(1);
    }
}
