#include "ATConsole.h"
#include "ATCommandsInterface.h"

ATConsole::ATConsole(
   Serial *terminal,
   int lineLength,
   int numLines,
   bool characterBased,
   ATCommandsInterface* atInterface)
   : Console(terminal,lineLength,numLines,characterBased), _atInterface(atInterface)  {
   
   // constructor
   atInterface->registerEventsHandler(this);
   _gettingSMSData = false;
}

ATConsole::~ATConsole() {
   
}

void ATConsole::processCommand() {
   if(strlen(_lineBuffer)==0)
       return;
   //_terminal->printf("ATConsole::processCommand()\r\n");
   _terminal->printf("\r\n");
    if(_gettingSMSData) {
       _terminal->printf("_gettingSMSData %s\r\n",_lineBuffer);
       strcpy(_smsMessage,_lineBuffer);
       _gettingSMSData = false;
       return;
    }
    
    if((strncmp(_lineBuffer,"h",_lineLength)==0)||
       (strncmp(_lineBuffer,"help",_lineLength)==0)) {
        _terminal->printf("Help.\r\n");
        _terminal->printf("   \"connect\": Connect to 3G network.\r\n");
        _terminal->printf("   \"disconnect\": Disconnect from 3G network.\r\n");
        return;
    }
    
    if(!_characterBased) {
       _lineBuffer[strlen(_lineBuffer)-2]=0x00;
    }
    
    //_terminal->printf("\r\ncmd: \"%s\"(%d)\r\n",_lineBuffer,strlen(_lineBuffer));
    _atInterface->execute(_lineBuffer, this, &_cmdResult, 1000);
    
    if(_cmdResult.result==ATCommandsInterface::ATResult::AT_OK&&!_gettingSMSData) {
       clearBuffer();
       _terminal->printf("OK\r\n");
    }
}

void ATConsole::update() {
    Console::update();
}

int ATConsole::onNewATResponseLine(ATCommandsInterface* pInst, const char* line) {
   _terminal->printf("%s\r\n",line);
   return OK;
}
  
int ATConsole::onNewEntryPrompt(ATCommandsInterface* pInst) {
   storeBuffer();
   clearBuffer();
   _terminal->printf("new entry prompt\r\n");
   _terminal->printf(">\r\n");
   _gettingSMSData = true;
   while(_gettingSMSData) {
      update();
      Thread::wait(10);
   }
   _terminal->printf("about to send: \"%s\"\r\n",_smsMessage);
   _atInterface->sendData(_smsMessage);
   return OK;
}

void ATConsole::onEvent(const char* atCode, const char* evt) {
   _terminal->printf("Unsolicited result code: %s - %s\r\n", atCode, evt);
}

/*virtual*/ void ATConsole::onDispatchStart() { }

/*virtual*/ void ATConsole::onDispatchStop() { }

bool ATConsole::isATCodeHandled(const char* atCode) { 
   if(strcmp("+CUSD", atCode) == 0 ) {
      return true;
   }
   if(strcmp("+COPS",atCode)==0) {
      return true;
   }
   return false;
}

/*virtual*/ char* ATConsole::getEventsEnableCommand() {
   return NULL; // no need to disable or enable commands
}

/*virtual*/ char* ATConsole::getEventsDisableCommand() {
   return NULL;
}