#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "net_3g_basic_http_test.cpp"
#endif

#include "core/fwk.h"
#include "mbed.h"
#include "rtos.h"
#include "if/VodafoneK3770.h"
#include "AdafruitThermal.h"

DigitalOut led1(LED1);

extern "C" void HardFault_Handler() {
    error("Hard Fault!\n");
}

// this is the main thread which checks for messages and sends them to the printer
void printerLoop(void const*) {
    VodafoneK3770 modem;                // setup modem
    AdafruitThermal printer(p13,p14);   // setup printer
    printer.begin();                    // and init it

    // declare space for phone number and message storage
    char numBuffer[20], msgBuffer[256];
    size_t numSMS; // variable to track number of received messages

    //modem.sendSM("07825608771","this is a test");

    // loop forever
    while(1) {
        DBG("Checking SM count");

        // retrieve the short message count into numSMS
        if(modem.getSMCount(&numSMS)==OK) {
            DBG("getSMCount success");
            DBG("numSMS: %d",numSMS);
            // check if any short messages have been received
            if(numSMS>0) {
                DBG("SM count > 0");
                // get the oldest short message in the queue
                if(modem.getSM(numBuffer,msgBuffer,256)==OK) {
                    DBG("message received");
                    DBG("num: %s",numBuffer);
                    DBG("msg: %s",msgBuffer);
                    // send it to the printer
                    printer.print(msgBuffer);
                    printer.print("\r\n");
                    // linefeed a couple of times
                    printer.feed(2);
                }
            }
        }
        // wait 500ms
        Thread::wait(500);
    }
}

// this is the main thread
int main() {
    // init the debug macros
    DBG_INIT();

    // create and launch printer thread
    Thread testTask(
        printerLoop, // function name
        NULL, osPriorityNormal, 1024 * 4);
    
    // loop forever, relinquish thread every 500ms
    while(1) {
        // toggle led1
        led1 = !led1;
        // wait 500ms
        Thread::wait(500);
    }

    return 0;
}
