#define __DEBUG__ 4 //Maximum verbosity
#ifndef __MODULE__
#define __MODULE__ "net_3g_basic_http_test.cpp"
#endif

#include "core/fwk.h"
#include "mbed.h"

#include "rtos.h"

#include "if/VodafoneK3770.h"
#include "HTTPClient.h"
#include "AdafruitThermal.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
void setLeds(bool a, bool b, bool c, bool d) {
  led1 = a;
  led2 = b;
  led3 = c;
  led4 = d;
}

extern "C" void HardFault_Handler() {
  error("Hard Fault!\n");
}

void test(void const*) {
  VodafoneK3770 modem;
  HTTPClient http;
  AdafruitThermal printer(p13,p14);
  printer.begin();

  char str[512];
  char numBuffer[20];
  char msgBuffer[256];

  //int ret = modem.connect("pp.vodafone.co.uk", "web", "web");
  //int ret = modem.connect("internet", "web", "web");
  int ret = OK;
  if(ret != OK)
    return;
  
  size_t numSMS;
  
  //modem.sendSM("07825608771","this is a test");
  
  while(true) {
    DBG("Checking SM count");
    
    if(modem.getSMCount(&numSMS)==OK) {
       DBG("getSMCount success");
       DBG("numSMS: %d",numSMS);
       if(numSMS>0) {
         DBG("SM count > 0");
         if(modem.getSM(numBuffer,msgBuffer,256)==OK) {
           DBG("message received");
           DBG("num: %s",numBuffer);
           DBG("msg: %s",msgBuffer);
           
           printer.print(msgBuffer);
           printer.feed(1);           
         }
       }
       
    }
    Thread::wait(5000);
    
  }
  
  //
    
  DBG("Trying to fetch page...");
  ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
  if (ret == OK) {
    DBG("Page fetched successfully - read %d characters", strlen(str));
    DBG("Result: %s", str);
  } else {
    WARN("Error - ret = %d - HTTP return code = %d", ret, http.getHTTPResponseCode());
  }

  HTTPMap map;
  HTTPText text(str, 512);
  map.put("Hello", "World");
  map.put("test", "1234");
  DBG("Trying to post data...");
  ret = http.post("http://httpbin.org/post", map, &text);
  if (ret == OK) {
    DBG("Executed POST successfully - read %d characters", strlen(str));
    DBG("Result: %s", str);
  } else {
    WARN("Error - ret = %d - HTTP return code = %d", ret, http.getHTTPResponseCode());
  }
  
  
  modem.disconnect();
  DBG("Disconnected");

  while (1) {
    Thread::wait(100);
  }
}

void keepAlive(void const*) {
  while (1) {
    led1 = !led1;
    Thread::wait(500);
  }
}

int main() {

  DBG_INIT();
  /*
  VodafoneK3770 threeg;
  int ret = threeg.connect("pp.vodafone.co.uk", "web", "web");
  if(ret==OK) {
    DBG("connection OK");
  }
  */

  Thread testTask(test, NULL, osPriorityNormal, 1024 * 4);
  keepAlive(NULL);

  return 0;
}
