#ifndef FARKLEGAME_H
#define FARKLEGAME_H

#include "Die.h"
#include "MMA8452.h"

#include <iostream>
#include <string>

using namespace std;

class FarkleGame{
    public:
        //Constructor
        FarkleGame();
        
        //Methods
        void dispIntro(uLCD_4DGL&, int);
        void init();
        
        //rolling/scoring methods
        void rollDice();
        void displayDice(uLCD_4DGL&, int);
        void loadVals(int);
        int calcScore();
        void updateScores();
        
        //display methods
        void dispFarkle(uLCD_4DGL&);
        void dispScore(uLCD_4DGL&);
        void dispTurn(uLCD_4DGL&);
        void scrnWipe(uLCD_4DGL&);

        //acc methods
        bool checkRoll(MMA8452&);
        
        //S&G
        int getDieVal(int);
        void setDieVal(int, int);
        
    private:
        Die Dice[6];
        int DiceVals[6];
        
        int turnScore;
        int rollScore;
        int farkles;
};

#endif