/**

Programmer: Andrew Shi
Title: Lab 4 - Farkle Game
Date: October 11 2021
Description: Main function

**/
#include "Die.h"
#include "FarkleGame.h"
#include "PinDetect.h"

#include "mbed.h"
#include <time.h>

using namespace std;

Serial pc(USBTX,USBRX);

PinDetect A(p21);
PinDetect B(p22);
PinDetect C(p23);

int main(){
    
    //clear system
    system("clear");
    
    //declare buttons
    A.mode(PullUp);
    B.mode(PullUp);
    C.mode(PullUp); //unused
    
    //declare uLCD screen
    uLCD_4DGL uLCD(p9,p10,p11);
    uLCD.cls();
    uLCD.display_control(PORTRAIT);
    
    //declare accelerometer
    MMA8452 acc(p28, p27, 40000);
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
    
    //declare dice number
    int numDice = 6;
    
    //initialize FarkleGame object
    FarkleGame game;
    
    game.scrnWipe(uLCD);
    
    //begin game
    while(1){
        //display intro and initialize values
        game.dispIntro(uLCD, numDice);
        game.init();
        
        //check for roll, adjust number of Dice
        while(!game.checkRoll(acc)){   
            if(!B){
                numDice = (numDice+1)%7;
                game.dispIntro(uLCD,numDice);
            }        
        }
        
        //roll dice when accelerometer is sensed, until A is clicked
        while(A){
            if(game.checkRoll(acc)){
                //roll dice and displar
                game.rollDice();
                game.displayDice(uLCD, numDice);
                
                //update scores
                game.loadVals(numDice);
                game.updateScores();
                
                //display screens based on scores
                if(game.calcScore() == 0){
                    game.dispFarkle(uLCD);
                    wait(3);
                    break;
                }
                else{
                    game.dispScore(uLCD);
                }
            }
        }
        
        //display turn end screen
        game.dispTurn(uLCD);
        //wait for button to be pressed
        while(A){
        }
        //reset numDice
        numDice = 6;
    }

}

