#include "Die.h"

#include <string>
#include <iostream>

#include <stdlib.h>     /* srand, rand */
#include <time.h>       /* time */

#define WHITE 0xFFFFFF

using namespace std;

//Constructors
Die::Die(){
    val = 1;
}

Die::Die(int v){
    if((v > 0) && (v < 7)){
        val = v;
    }
    else{
        val = 1;
    }
}

//Public Methods
void Die::rollDie(){
    
    val = rand()%6+1;
}

//6 draw functions
void Die::draw1(int pos, uLCD_4DGL& scr){
    int ycent = 42*(((pos-1)/3)+1)-21;
    int xcent = 42*(((pos-1)%3)+1)-21;
    
    int width = 20;
    
    int rad = 5;
    
    scr.rectangle(xcent-width, ycent-width, xcent+width, ycent+width, WHITE);
    scr.filled_circle(xcent,ycent,rad,WHITE);
}

void Die::draw2(int pos, uLCD_4DGL& scr){
    int ycent = 42*(((pos-1)/3)+1)-21;
    int xcent = 42*(((pos-1)%3)+1)-21;
    
    int width = 20;
    
    int rad = 5;
    
    scr.rectangle(xcent-width, ycent-width, xcent+width, ycent+width, WHITE);
    scr.filled_circle(xcent+12,ycent+12,rad,WHITE);
    scr.filled_circle(xcent-12,ycent-12,rad,WHITE);
}

void Die::draw3(int pos, uLCD_4DGL& scr){
    int ycent = 42*(((pos-1)/3)+1)-21;
    int xcent = 42*(((pos-1)%3)+1)-21;
    
    int width = 20;
    
    int rad = 5;
    
    scr.rectangle(xcent-width, ycent-width, xcent+width, ycent+width, WHITE);
    scr.filled_circle(xcent+12,ycent+12,rad,WHITE);
    scr.filled_circle(xcent,ycent,rad,WHITE);
    scr.filled_circle(xcent-12,ycent-12,rad,WHITE);
}

void Die::draw4(int pos, uLCD_4DGL& scr){
    int ycent = 42*(((pos-1)/3)+1)-21;
    int xcent = 42*(((pos-1)%3)+1)-21;
    
    int width = 20;
    
    int rad = 5;
    
    scr.rectangle(xcent-width, ycent-width, xcent+width, ycent+width, WHITE);
    scr.filled_circle(xcent+12,ycent+12,rad,WHITE);
    scr.filled_circle(xcent+12,ycent-12,rad,WHITE);
    scr.filled_circle(xcent-12,ycent+12,rad,WHITE);
    scr.filled_circle(xcent-12,ycent-12,rad,WHITE);
}

void Die::draw5(int pos, uLCD_4DGL& scr){
    int ycent = 42*(((pos-1)/3)+1)-21;
    int xcent = 42*(((pos-1)%3)+1)-21;
    
    int width = 20;
    
    int rad = 5;
    
    scr.rectangle(xcent-width, ycent-width, xcent+width, ycent+width, WHITE);
    scr.filled_circle(xcent,ycent,rad,WHITE);
    scr.filled_circle(xcent+12,ycent+12,rad,WHITE);
    scr.filled_circle(xcent+12,ycent-12,rad,WHITE);
    scr.filled_circle(xcent-12,ycent+12,rad,WHITE);
    scr.filled_circle(xcent-12,ycent-12,rad,WHITE);
}

void Die::draw6(int pos, uLCD_4DGL& scr){
    int ycent = 42*(((pos-1)/3)+1)-21;
    int xcent = 42*(((pos-1)%3)+1)-21;
    
    int width = 20;
    
    int rad = 5;
    
    scr.rectangle(xcent-width, ycent-width, xcent+width, ycent+width, WHITE);
    scr.filled_circle(xcent-12,ycent,rad,WHITE);
    scr.filled_circle(xcent+12,ycent,rad,WHITE);
    scr.filled_circle(xcent+12,ycent+12,rad,WHITE);
    scr.filled_circle(xcent+12,ycent-12,rad,WHITE);
    scr.filled_circle(xcent-12,ycent+12,rad,WHITE);
    scr.filled_circle(xcent-12,ycent-12,rad,WHITE);
}

//display Die based on value
void Die::displayDie(int position, uLCD_4DGL& screen){
       if(val == 1){draw1(position,screen);}
       if(val == 2){draw2(position,screen);}
       if(val == 3){draw3(position,screen);}
       if(val == 4){draw4(position,screen);}
       if(val == 5){draw5(position,screen);}
       if(val == 6){draw6(position,screen);}
}



//S&G
void Die::setVal(int v){
    val = v;
}

int Die::getVal(){
    return val;
}