#include "Die.h"
#include "FarkleGame.h"

#include <string>
#include <iostream>
#include <sstream>

using namespace std;

//Constructors
FarkleGame::FarkleGame(){
    Die Dice[6];
    int DiceVals[6];
    
    int turnScore = 0;
    int rollScore = 0;
    int farkles = 0;
}

//Method
void FarkleGame::dispIntro(uLCD_4DGL& scr, int nd){
    scr.cls();
    scr.display_control(PORTRAIT);

    scr.text_width(2);
    scr.text_height(2);
    scr.locate(0,1);
    scr.printf("Shake\n");
    scr.printf("Board\n");
    scr.printf("------\n");
    scr.printf("To\n");
    scr.printf("Roll\n");
    scr.printf("%d Dice", nd);
}

void FarkleGame::init(){
    turnScore = 0;
    rollScore = 0;
    farkles = 0;
}

void FarkleGame::rollDice(){
    for(int i = 0; i < 6; i++){
        Dice[i].rollDie();
    }
}

void FarkleGame::displayDice(uLCD_4DGL& scr, int nd){
    
    scr.cls();
    scr.display_control(PORTRAIT);
    
    for(int i = 0; i < nd; i++){
        Dice[i].displayDie(i+1, scr);
    }
    
}

void FarkleGame::loadVals(int nd){
    for(int i = 0; i < 6; i++){
        DiceVals[i] = 0;
    }
    for(int i = 0; i < nd; i++){
        if(Dice[i].getVal() == 1){
            DiceVals[0]++;
        }else if(Dice[i].getVal() == 2){
            DiceVals[1]++;
        }else if(Dice[i].getVal() == 3){
            DiceVals[2]++;
        }else if(Dice[i].getVal() == 4){
            DiceVals[3]++;
        }else if(Dice[i].getVal() == 5){
            DiceVals[4]++;
        }else if(Dice[i].getVal() == 6){
            DiceVals[5]++;
        }
    }    
}

int FarkleGame::calcScore(){
    //Scores will be checked in descending order of value
    
    //check for 6
    for(int i = 0; i < 6; i++){
        if(DiceVals[i] == 6){
            return 3000;
        }
    }
    
    //check for 2triplets
    int tripCount = 0;
    for(int i = 0; i < 6; i++){
        if(DiceVals[i] == 3) tripCount++;
    }
    if(tripCount == 2){
        return 2500;
    }
    
    //check for 5
    for(int i = 0; i < 6; i++){
        if(DiceVals[i] == 5){
            return 2000;
        }
    }
    
    //check for 123456
    int singCount = 0;
    for(int i = 0; i < 6; i++){
        if(DiceVals[i] == 1) singCount++;
    }
    if(singCount == 6){
        return 1500;
    }
    
    //check for 3doubs
    int doubCount = 0;
    for(int i = 0; i < 6; i++){
        if(DiceVals[i] == 2) doubCount++;
    }
    if(doubCount == 3){
        return 1500;
    }

    //check for 4
    for(int i = 0; i < 6; i++){
        if(DiceVals[i] == 4){
            return 1000;
        }
    }
    
    //check trips
    if(tripCount == 1){
        if(DiceVals[0] == 3){
            return 1000;
        }else if(DiceVals[5] == 3){
            return 600;
        }
        else if(DiceVals[4] == 3){
            return 500;
        }else if(DiceVals[3] == 3){
            return 400;
        }else if(DiceVals[2] == 3){
            return 300;
        }else if(DiceVals[1] == 3){
            return 200;
        }
    }
    
    //check 1
    if(DiceVals[0] != 0){
        return 100;
    }
    
    //check 5
    if(DiceVals[4] != 0){
        return 50;
    }

    farkles++;

    return 0;
}

void FarkleGame::updateScores(){
    rollScore = calcScore();
    turnScore += rollScore;
    if(farkles > 0){
        turnScore = 0;
    }
}

void FarkleGame::dispFarkle(uLCD_4DGL& scr){
    scr.text_width(2);
    scr.text_height(2);
    scr.locate(0,6);
    
    scr.printf("FARKLE!");
}

void FarkleGame::dispScore(uLCD_4DGL& scr){
    scr.text_width(1);
    scr.text_height(1);
    scr.locate(0,11);
    
    scr.printf("\nThis Turn: %d\n", turnScore);
    scr.printf("\nThis Roll: %d\n", rollScore);
    //scr.printf("Val Counts: %d %d %d %d %d %d", DiceVals[0], DiceVals[1], DiceVals[2], DiceVals[3], DiceVals[4], DiceVals[5]);
}

void FarkleGame::dispTurn(uLCD_4DGL& scr){
    scr.cls();
    scr.display_control(PORTRAIT);

    scr.text_width(2);
    scr.text_height(2);
    scr.locate(0,1);
    scr.printf("Your\n");
    scr.printf("Turn\n");
    scr.printf("Score\n");
    scr.printf("-----\n");
    scr.printf("%d\n", turnScore);
}

void FarkleGame::scrnWipe(uLCD_4DGL& scr){
    scr.cls();
}

bool FarkleGame::checkRoll(MMA8452& a){
    double x = 0;
    double y = 0;
    double z = 0;
    
    a.readXYZGravity(&x,&y,&z);
    
    return (x > 0.5 || x < -0.5 || y > 0.5 || y < -0.5);
}

//S&G
void FarkleGame::setDieVal(int pos, int v){
    Dice[pos-1].setVal(v);
}

int FarkleGame::getDieVal(int pos){
    return Dice[pos-1].getVal();
}