#include "mbed.h"
#include "Motor.h"
#include "ReceiverIR.h"
#include "Speaker.h"

//Asha Harris, Teferi Taylor
//Hamblen ECE 4180 Lab 4 IoT Robot and IR sensor program
// 10/27/16

AnalogIn irSens(p15);
Speaker mySpeaker(p22);

BusOut myled(LED1,LED2,LED3,LED4);
Serial blue(p28,p27);

//motor initializations..
Motor A(p25, p6, p5); // pwm, fwd, rev, can brake
Motor B(p26, p7, p8); // pwm, fwd, rev, can brake
int main()
{
    char bnum=0;
    char bhit=0;
    while(1) {
        //mySpeaker.PlayNote(969.0*irSens,0.6,0.1);
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                myled[0] = 1;
                            } else {
                                myled[0] = 0;
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                myled[1] = 1;
                            } else {
                                myled[1] = 0;
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                myled[2] = 1;
                            } else {
                                myled[2] = 0;
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                myled[3] = 1;
                            } else {
                                myled[3] = 0;
                            }
                            break;
                        case '5': //button 5 up arrow "forward"
                            if (bhit=='1') {
                                A.speed(0.4);
                                B.speed(0.4);
                                mySpeaker.PlayNote(969.0*irSens,0.6,0.1); //speaker plays tone at frequency corresponding to IR sensor readings
                            } else {
                                
                                //A.stop(1);
                                //B.stop(1);
                                mySpeaker.PlayNote(969.0*irSens,0.6,0.1);
                            }
                            break;
                        case '6': //button 6 down arrow "reverse"
                            if (bhit=='1') {
                                A.speed(-0.4);
                                B.speed(-0.4);
                                mySpeaker.PlayNote(969.0*irSens,0.6,0.1);
                            } else {
                                //A.stop(1);
                                //B.stop(1);
                                mySpeaker.PlayNote(969.0*irSens,0.6,0.1);
                            }
                            break;
                        case '7': //button 7 left arrow "left"
                            if (bhit=='1') {
                                A.speed(.5);
                                B.speed(-.5);
                                mySpeaker.PlayNote(969.0*irSens,0.6,0.1);
                            } else {
                                A.speed(0);
                                B.speed(0);
                                mySpeaker.PlayNote(969.0*irSens,0.6,0.1);

                            }
                            break;
                        case '8': //button 8 right arrow "right"
                            if (bhit=='1') {
                                B.speed(.5);
                                A.speed(-.5);
                                mySpeaker.PlayNote(969.0*irSens,0.6,0.1);
                            } else {
                                B.speed(0);
                                A.speed(0);
                                mySpeaker.PlayNote(969.0*irSens,0.6,0.1);
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
}
