#include "mbed.h"
#include "globals.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include <mpr121.h>


DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
InterruptIn interrupt(p26);
uLCD_4DGL uLCD(p13,p14,p15); 
AnalogOut DACout(p18);
wave_player player(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd");
I2C i2c(p9, p10);
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

int ballNum = 0;
int tank_x;
int tank_y;
int balls_x[15];
int balls_y[15];
int balls_color[15]; 
int lives = 1;
int dist = 0;
bool win = false;
bool playing = true;
volatile bool chosen = false;
int noOfLives;
volatile bool moved = false;
Mutex lcd_mutex;

void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
    }
    led4=key_code & 0x01;
    led3=(key_code>>1) & 0x01;
    led2=(key_code>>2) & 0x01;
    led1=(key_code>>3) & 0x01;
    //uLCD.printf("%d", key_code);
    noOfLives = key_code;
    chosen = true;
}


void tankMove() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
    }
    dist = 0;
    if(key_code == 5) {
        dist = 5; 
        moved = true;  
    } else if(key_code == 7){
        dist = -5; 
        moved = true;  
    }
}

void game_init(){
    lcd_mutex.lock();
    uLCD.cls();
    const unsigned ImageHeight=128;
    const unsigned ImageWidth=128;
    //"c" region to display
    double MinRe = -0.75104;
    double MaxRe = -0.7408;
    double MinIm = 0.10511;
    double MaxIm = MinIm+(MaxRe-MinRe)*ImageHeight/ImageWidth;
    double Re_factor = (MaxRe-MinRe)/(ImageWidth-1);
    double Im_factor = (MaxIm-MinIm)/(ImageHeight-1);
    unsigned MaxIterations = 2048;
    for(unsigned y=0; y<ImageHeight; ++y) {
        double c_im = MaxIm - y*Im_factor;
        for(unsigned x=0; x<ImageWidth; ++x) {
            double c_re = MinRe + x*Re_factor;
            double Z_re = c_re, Z_im = c_im;
            int niterations=0;
            for(unsigned n=0; n<MaxIterations; ++n) {
                double Z_re2 = Z_re*Z_re, Z_im2 = Z_im*Z_im;
                if(Z_re2 + Z_im2 > 4) {
                    niterations = n;
                    break;
                }
                Z_im = 2*Z_re*Z_im + c_im;
                Z_re = Z_re2 - Z_im2 + c_re;
            }
            if (niterations!=(MaxIterations-1))
                uLCD.pixel(x,y,((niterations & 0xF00)<<12)+((niterations & 0xF0)<<8)+((niterations & 0x0F)<<4) );
        }
    }
    uLCD.cls();
    lcd_mutex.unlock();
    led1 = 0; led2 = 0; led3 = 0; led4 = 0; 
    for(int i = 0 ; i  <15; i++ ){
        balls_x[i] = rand() % 120 + 5; 
        balls_y[i] = 3;  
        balls_color[i] = rand() % 2 +1;
    } 
    tank_x= 60;
    tank_y= 122;
    //uLCD.background_color(SKY_COLOR);
    lcd_mutex.lock();
    uLCD.filled_circle(tank_x+2, tank_y, 3, BLUE);
    uLCD.filled_circle(tank_x+9, tank_y, 3, BLUE);
    uLCD.filled_rectangle(tank_x+6,tank_y-11,tank_x+7,tank_y-14, RED);
    uLCD.filled_rectangle(tank_x, tank_y, tank_x+12, tank_y-10, RED);
    lcd_mutex.unlock();
    
}

void moveBall(){
    uLCD.filled_rectangle(balls_x[ballNum], balls_y[ballNum],balls_x[ballNum]+3, balls_y[ballNum]+3, BLACK);
    balls_y[ballNum] = balls_y[ballNum] + 2;
    if(balls_color[ballNum] == 1){
        uLCD.filled_rectangle(balls_x[ballNum], balls_y[ballNum],balls_x[ballNum]+3, balls_y[ballNum]+3, BLUE);
    } else {
        uLCD.filled_rectangle(balls_x[ballNum], balls_y[ballNum],balls_x[ballNum]+3, balls_y[ballNum]+3, RED);
    }
}

void thread1(void const *args)
{
   while(balls_y[ballNum] < 116){
        lcd_mutex.lock();
        moveBall();
        lcd_mutex.unlock();
        if(balls_y[ballNum] >= 116){
            lcd_mutex.lock();
            uLCD.filled_rectangle(balls_x[ballNum], balls_y[ballNum],balls_x[ballNum]+3, balls_y[ballNum]+3, BLACK);
            lcd_mutex.unlock();
            ballNum++;   
        }
    }
    Thread::wait(1000);
}

void thread2(void const *args){
    FILE *wave_file;
    wave_file=fopen("/sd/wavfiles/sweeper.wav","r");
    if(wave_file == NULL) {
        led1 =1;
    } else {
        player.play(wave_file);
        led1 =0;
    }
    fclose(wave_file);   
}

void thread3(void const *args)
{
    while(playing){
    interrupt.fall(&tankMove);
    interrupt.mode(PullUp);
    while(!moved){}
    lcd_mutex.lock();
    uLCD.filled_circle(tank_x+2, tank_y, 3, BLACK);
    uLCD.filled_circle(tank_x+9, tank_y, 3, BLACK);
    uLCD.filled_rectangle(tank_x+6,tank_y-11,tank_x+7,tank_y-14, BLACK);
    uLCD.filled_rectangle(tank_x, tank_y, tank_x+12, tank_y-10, BLACK);
    
    tank_x = tank_x + dist;
    
    uLCD.filled_circle(tank_x+2, tank_y, 3, BLUE);
    uLCD.filled_circle(tank_x+9, tank_y, 3, BLUE);
    uLCD.filled_rectangle(tank_x+6,tank_y-11,tank_x+7,tank_y-14, RED);
    uLCD.filled_rectangle(tank_x, tank_y, tank_x+12, tank_y-10, RED);
    lcd_mutex.unlock();
    moved = false;
    }
    //Thread::wait(1000);   
}

void gameover(){
    uLCD.cls();
    led1=1;
    uLCD.locate(0,10);
    if(win){
        uLCD.printf("Win");   
    } else {
        uLCD.printf("Lose");   
    }
}
 
int main() {
   
    Thread t2(thread2);
    lcd_mutex.lock();
    uLCD.locate(0,5);
    uLCD.printf("Touch to Start");
    lcd_mutex.unlock();
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    while(!chosen){};
    //t2.terminate();
    game_init();
    Thread t1(thread1);
    Thread t3(thread3);
    while(ballNum < 15) {
        Thread::wait(50);
        lcd_mutex.lock();
        uLCD.locate(0,0);
        uLCD.printf("Lives: %d",lives);
        lcd_mutex.unlock();
        if((balls_x[ballNum] < tank_x+12) && (balls_x[ballNum]+3 > tank_x) &&  
        (balls_y[ballNum] > tank_y-10)){ 
            lcd_mutex.lock();
            uLCD.filled_rectangle(balls_x[ballNum], balls_y[ballNum],balls_x[ballNum]+3, balls_y[ballNum]+3, BLACK);
            lcd_mutex.unlock();
            if(balls_color[ballNum] == 1){
                 lives--;  
            } else {
                lives++;   
            }
            //ballNum++;   
        }
        if(lives == 0){
            playing = false;
            t1.terminate();
            t3.terminate();
            gameover();
            break;
        } else if(lives ==3){
            playing = false;
            win= true;
            t1.terminate();
            t3.terminate();
            gameover();
            break;
        }   
    }
    t1.terminate();
    t3.terminate();
     gameover();
}