#include "mbed.h"
#include "getGPS.h"

Serial pc(SERIAL_TX, SERIAL_RX);
GPS gps(D1, D0);// tx,rx

int main()
{
    pc.printf("\r\n");
    pc.printf("GPS Start\r\n");
    
    /* 1秒ごとに現在地を取得してターミナル出力 */
    while(1) {
        if(gps.getgps()){ //現在地取得
            pc.printf("Time(UTS): ");
            pc.printf("%lf\r\n", gps.gpstime);
            pc.printf("lat long: ");
            pc.printf("(%lf, %lf)\r\n", gps.latitude, gps.longitude);//緯度と経度を出力
            pc.printf("hdop: ");
            pc.printf("%lf\r\n",gps.hdop);//位置情報精度
            pc.printf("hight: ");
            pc.printf("%lf\r\n",gps.hight);//高度
            pc.printf("direction: ");
            pc.printf("%lf\r\n",gps.direction);//進行方向
            pc.printf("speed: ");
            pc.printf("lf\r\n",gps.speed);//速度
            pc.printf("===================================\r\n");
            
        }else{
            pc.printf("No data\r\n");//データ取得に失敗した場合
        }
        wait(3);
    }
}
