#include "mbed.h"
#include "getGPS.h"

GPS::GPS(PinName gpstx,PinName gpsrx): _gps(gpstx,gpsrx)
{
    gpstime =0; //GPSから取得した時刻。
    longitude =0;
    latitude =0;
    hdop =0; //位置情報精度
    hight =0; //海抜高度
    //GPVTG
    direction =0; //進行方向(真北基準)
    speed =0; //対地速度kmph
    _gps.baud(GPSBAUD);
    _gps.printf("$PMTK314,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*29");
}

bool GPS::getgps()
{
    char gps_data[256];
    char gpgga_data[256];
    char gpvtg_data[256];
    
    int i;
    int flag1 = 0; //GPGGA
    int flag2 = 0; //GPVTG
    for (int p=0; p<50; p++){
        while(_gps.getc() != '$'); //$マークまで読み飛ばし
        i = 0;

        /* gpa_data初期化 */
        for(int j = 0; j < 256; j++)
            gps_data[j] = '\0';

        /* NMEAから一行読み込み */
        while((gps_data[i] = _gps.getc()) != '\r') {
            i++;
            if(i == 256) {
                i = 255;
                break;
            }
        }
        if (strstr(gps_data, "GPGGA") != NULL){
            strcpy(gpgga_data,gps_data);
            flag1=1;
        }
        if(strstr(gps_data, "GPVTG") != NULL){
            strcpy(gpvtg_data,gps_data);
            flag2=1;
        }
        if (flag1 * flag2== 0){
            break;
        }
    } //GPGGAとGPVTGが取得できるまで1行ずつ読む
    //For GPGGA================================================================
    int rlock;
    char ns,ew;
    double w_time, raw_longitude, raw_latitude;
    int satnum;

    if(sscanf(gpgga_data, "GPGGA,%lf,%lf,%c,%lf,%c,%d,%d,%lf,%lf", &w_time, &raw_latitude, &ns, &raw_longitude, &ew, &rlock, &satnum, &hdop, &hight) > 1) {
        /* 座標を求める (度と分で分割して度にする。intは切り捨て)*/
        gpstime = w_time;
        int latitude_dd = (int)(raw_latitude / 100);
        int longitude_dd = (int)(raw_longitude / 100);
        double latitude_md = (raw_latitude - latitude_dd * 100) / 60;
        double longitude_md = (raw_longitude - longitude_dd * 100) / 60;
        latitude = latitude_dd + latitude_md;
        longitude = longitude_dd + longitude_md;
        flag1 = 1;
    }else{
        flag1 = 0; //GGAセンテンスの情報が欠けている時
    }
    
    //For GPVTG================================================================
    char c1, c2,c3;
    double f1, f2, f3, f4;
    if(sscanf(gpvtg_data, "GPVTG, %lf, %c, %lf, %c, %lf, %c, %lf", &f1, &c1, &f2, &c2, &f3, &c3, &f4)>1){
        direction = f1;
        speed = f4;
        flag2 = 1;
    }else{
        flag2 = 0;
    }
    //return
    if (flag1*flag2 ==1){
        return true;
    }else{
        return false;
    }
    
    
}
