/*
 * ADKTerm
 * 
 * Written by p07gbar
 * 
 * This program is just a simple serial port program for comunication with mbedWrapper
 */
#include "mbed.h"
#include "AndroidAccessory.h"


#define OUTL 100
#define INBL 100





class AdkTerm :public AndroidAccessory {
public:
    AdkTerm():AndroidAccessory(INBL,OUTL,
                                       "ARM",
                                       "mbed",
                                       "mbed Terminal",
                                       "0.1",
                                       "http://www.mbed.org",
                                       "0000000012345678"),pc(USBTX,USBRX) {};
    virtual int callbackRead(u8 *buff, int len);
    virtual void setupDevice();
    virtual void resetDevice();
    virtual int callbackWrite();

private:
    void serialIRQ();
    char buffer[OUTL];
    int bcount;
    Serial pc;
};



void AdkTerm::setupDevice() {
    pc.printf("Welcome to adkTerm\n\n\n\n\n\n\r");
    pc.attach(this, &AdkTerm::serialIRQ, Serial::RxIrq);
    for (int i = 0; i<OUTL; i++) {
        buffer[i] = 0;
    }
    bcount = 0;

}


void AdkTerm::resetDevice() {
    pc.printf("adkTerm reset\n\r");
    for (int i = 0; i<OUTL; i++) {
        buffer[i] = 0;
    }
    bcount = 0;
}

int AdkTerm::callbackRead(u8 *buf, int len) {
    pc.printf("%i  %s\n\r\n\n\n",len,buf);
    for (int i = 0; i<INBL;i++) {
        buf[i] = 0;
    }
    return 0;
}

int AdkTerm::callbackWrite() {
    pc.printf("DoneWrite\n\r");
    
    return 0;
}


void AdkTerm::serialIRQ() {
    buffer[bcount] = pc.getc();
    pc.putc(buffer[bcount]);

    if (buffer[bcount] == '\n' || buffer[bcount] == '\r') {
        u8* wbuf = _writebuff;
        for (int i = 0; i<OUTL; i++) {
            wbuf[i] = buffer[i];
            buffer[i] = 0;
        }
        pc.printf("Sending: %s\n\r",wbuf);
        
        this->write(wbuf,bcount);
        bcount = 0;
    } else {
        if (buffer[bcount] != 0x08 && buffer[bcount] != 0x7F ) {
            bcount++;
            if (bcount == OUTL) {
                bcount = 0;
            }
        } else {
        bcount--;
        
        }
    }
}



AdkTerm AdkTerm;



int main() {
    printf("Android Development Kit: start\r\n");

    AdkTerm.setupDevice();
    USBInit();
    while (1) {
        USBLoop();
    }

}
