#include "mbed.h"              
#include "custom.h"

state current_state = WAITING_FOR_OPEN_REQUEST;

InterruptIn buttonOK(p5);
InterruptIn buttonDENY(p6);
DigitalOut flash(LED4);
DigitalOut myGreen(LED5);
DigitalOut myRed(LED6); 

Serial pc(PTD3, PTD2);
Serial xbtalk(USBTX, USBRX);

 
void requestApproved() {
    if (current_state == VALID_REQUEST_MADE) { //we can only approve a request if we are in the correct state
        current_state = DOOR_OPENED;
    }
}
 
void requestDenied() {
    if (current_state == VALID_REQUEST_MADE) {
        //close the door and/or keep the door closed
        current_state = DOOR_CLOSED;
    }
}

bool readXBRequest() { //TODO: read a string from XB, terminating with \n. Check it against our password and return true if good.
    return false;
}
 
bool sendValid() { //TODO: actually send the string "valid"
    return false;
}
bool sendOkay() { //TODO: actually send the string "okay"
    return false;
}

int timer = 0;

int main() {
    buttonOK.rise(&requestApproved);
    buttonDENY.rise(&requestDenied);
    myRed = 0;
    myGreen = 0;
    flash = 0;
     
//    WAITING_FOR_OPEN_REQUEST, VALID_REQUEST_MADE, DOOR_OPENED, DOOR_CLOSED } state;     
    while (1) {
        switch (current_state) {
            case WAITING_FOR_OPEN_REQUEST:
                //keep reading characters on the radio until we see a \n, then parse it to see if it's good. 
                //On success: VALID_REQUEST_MADE
                //On fail: DOOR_CLOSED                
                if (readXBRequest()) {
                    current_state = VALID_REQUEST_MADE;
                    timer = 0;
                    sendValid();
                } else {
                    current_state = DOOR_CLOSED;
                }
                break;
            case VALID_REQUEST_MADE: //they've made a good request, we have 15 seconds to either accept or deny that request
                if (timer > 15000) { //we'll open the door because we timed out
                    current_state = DOOR_OPENED;
                }  else { //we are still waiting for a button press (which will exit this state)
                    //do nothing
                    flash = !flash;
                }                
                break;
            case DOOR_OPENED:
                //we pressed the open button OR the 15 seconds timed out
                //turn on the door open opened LED
                //send a command via xbee "okay"
                sendOkay();
                flash = 0;
                myGreen = 1;
                myRed = 0;
                wait_ms(5000);
                current_state = WAITING_FOR_OPEN_REQUEST;
                break;
            case DOOR_CLOSED:
                //we pressed the closed button to keep the door closed, no terrorists allowed in the cockpit.
                myGreen = 0;
                myRed = 1;
                flash = 0;
                wait_ms(5000);
                current_state = WAITING_FOR_OPEN_REQUEST;
                break;                          
        }
        wait_ms(100);
        if (current_state == VALID_REQUEST_MADE) {
            timer += 100;
        } else {
            timer = 0;
        }        
    }

//    while (xbtalk.readable()) {
//        xbtalk.printf("at");
//        pc.printf("we got %c" , xbtalk.getc());
//        wait(1);
//    }
            
}

