#include "Trace.h"

LCD_DISCO_F429ZI lcdT;
//extern Serial pc;

void clean(){
    lcdT.Clear(COULEUR_FOND);
}

void DisplayMatrix(int xexp, int yexp, matrice* mat, int TaillePix,long long int couleur){
    lcdT.SetTextColor(couleur);
    matrice WorkingMatrix = *mat; //On récupère une matrice à partir du pointeur que l'on a donné
    for(int y=0;y<WorkingMatrix.tailleY;y++){   //On regarde chaque élément de la matrice et on voit si on doit ou non le colorer.
        for(int x=0;x<WorkingMatrix.tailleX;x++){
            if(WorkingMatrix.tableau[WorkingMatrix.tailleY-y-1][x]==1){
                lcdT.FillRect(yexp + TaillePix * y,xexp + TaillePix * x,TaillePix,TaillePix);
            }
        }
    }
    free(mat);  //On libère la RAM occupée par la matrice
    /*lcdT.SetTextColor(LCD_COLOR_BLUE);    //lignes de test
    lcdT.FillRect(xinit,yinit,TaillePix,TaillePix); */
}

void DisplayMatrixClean(int xexp, int yexp, matrice* mat, int TaillePix,long long int couleur,long long int couleurFond){
    //pc.printf("DebutTrace\n");
    lcdT.SetTextColor(couleurFond); //Avant de faire comme la fonction précédente on trace un rectangle en fond de ce que l'on va tracer.
    matrice WorkingMatrix = *mat;
    if(WorkingMatrix.tailleX<TailleMatrice && WorkingMatrix.tailleX<TailleMatrice){
        //pc.printf("Matrice Tracable\n");
        lcdT.FillRect(yexp,xexp,TaillePix * WorkingMatrix.tailleY,TaillePix * WorkingMatrix.tailleX);
        lcdT.SetTextColor(couleur);
        for(int y=0;y<WorkingMatrix.tailleY;y++){
            for(int x=0;x<WorkingMatrix.tailleX;x++){
                if(WorkingMatrix.tableau[WorkingMatrix.tailleY-y-1][x]==1){
                    lcdT.FillRect(yexp + TaillePix * y,xexp + TaillePix * x,TaillePix,TaillePix);
                    //pc.printf("y: %i/%i  x: %i/%i\n",y,WorkingMatrix.tailleY,x,WorkingMatrix.tailleX);
                }
            }
        }
    }
    //pc.printf("Liberation\n");
    free(mat);
    //pc.printf("FinTrace\n");
    /*lcdT.SetTextColor(LCD_COLOR_BLUE);    //lignes de test
    lcdT.FillRect(xinit,yinit,TaillePix,TaillePix); */
}

void DM_test(){
    DisplayMatrixClean(35,35,BS_graphe(),5,LCD_COLOR_BLACK,LCD_COLOR_WHITE);
    wait(1);
    lcdT.Clear(0xFFFFFFFF);
    BS_displayChiffreClean(35,125,745,5,LCD_COLOR_RED,LCD_COLOR_BLUE);
    BS_displayChiffreClean(135,125,7,5,LCD_COLOR_RED,LCD_COLOR_BLUE);
    BS_displayChiffre100Clean(35,25,745,5,LCD_COLOR_RED,LCD_COLOR_BLUE);
}


//Banque de symboles

matrice *BS_smile(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=16;
    (*ret).tailleX=16;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=1;    (*ret).tableau[0][6]=1;    (*ret).tableau[0][7]=1;    (*ret).tableau[0][8]=1;    (*ret).tableau[0][9]=1;    (*ret).tableau[0][10]=1;    (*ret).tableau[0][11]=0;    (*ret).tableau[0][12]=0;    (*ret).tableau[0][13]=0;    (*ret).tableau[0][14]=0;    (*ret).tableau[0][15]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;    (*ret).tableau[1][11]=1;    (*ret).tableau[1][12]=1;    (*ret).tableau[1][13]=0;    (*ret).tableau[1][14]=0;    (*ret).tableau[1][15]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;    (*ret).tableau[2][11]=0;    (*ret).tableau[2][12]=0;    (*ret).tableau[2][13]=1;    (*ret).tableau[2][14]=0;    (*ret).tableau[2][15]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;    (*ret).tableau[3][11]=0;    (*ret).tableau[3][12]=0;    (*ret).tableau[3][13]=0;    (*ret).tableau[3][14]=1;    (*ret).tableau[3][15]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=1;    (*ret).tableau[4][11]=0;    (*ret).tableau[4][12]=0;    (*ret).tableau[4][13]=0;    (*ret).tableau[4][14]=1;    (*ret).tableau[4][15]=0;
    (*ret).tableau[5][0]=1;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=1;    (*ret).tableau[5][11]=0;    (*ret).tableau[5][12]=0;    (*ret).tableau[5][13]=0;    (*ret).tableau[5][14]=0;    (*ret).tableau[5][15]=1;
    (*ret).tableau[6][0]=1;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=1;    (*ret).tableau[6][11]=0;    (*ret).tableau[6][12]=0;    (*ret).tableau[6][13]=0;    (*ret).tableau[6][14]=0;    (*ret).tableau[6][15]=1;
    (*ret).tableau[7][0]=1;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;    (*ret).tableau[7][11]=0;    (*ret).tableau[7][12]=0;    (*ret).tableau[7][13]=0;    (*ret).tableau[7][14]=0;    (*ret).tableau[7][15]=1;
    (*ret).tableau[8][0]=1;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;    (*ret).tableau[8][11]=0;    (*ret).tableau[8][12]=0;    (*ret).tableau[8][13]=0;    (*ret).tableau[8][14]=0;    (*ret).tableau[8][15]=1;
    (*ret).tableau[9][0]=1;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;    (*ret).tableau[9][11]=0;    (*ret).tableau[9][12]=0;    (*ret).tableau[9][13]=0;    (*ret).tableau[9][14]=0;    (*ret).tableau[9][15]=1;
    (*ret).tableau[10][0]=1;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=1;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;    (*ret).tableau[10][11]=1;    (*ret).tableau[10][12]=0;    (*ret).tableau[10][13]=0;    (*ret).tableau[10][14]=0;    (*ret).tableau[10][15]=1;
    (*ret).tableau[11][0]=0;    (*ret).tableau[11][1]=1;    (*ret).tableau[11][2]=0;    (*ret).tableau[11][3]=0;    (*ret).tableau[11][4]=0;    (*ret).tableau[11][5]=1;    (*ret).tableau[11][6]=1;    (*ret).tableau[11][7]=1;    (*ret).tableau[11][8]=1;    (*ret).tableau[11][9]=1;    (*ret).tableau[11][10]=1;    (*ret).tableau[11][11]=0;    (*ret).tableau[11][12]=0;    (*ret).tableau[11][13]=0;    (*ret).tableau[11][14]=1;    (*ret).tableau[11][15]=0;
    (*ret).tableau[12][0]=0;    (*ret).tableau[12][1]=1;    (*ret).tableau[12][2]=0;    (*ret).tableau[12][3]=0;    (*ret).tableau[12][4]=0;    (*ret).tableau[12][5]=0;    (*ret).tableau[12][6]=0;    (*ret).tableau[12][7]=0;    (*ret).tableau[12][8]=0;    (*ret).tableau[12][9]=0;    (*ret).tableau[12][10]=0;    (*ret).tableau[12][11]=0;    (*ret).tableau[12][12]=0;    (*ret).tableau[12][13]=0;    (*ret).tableau[12][14]=1;    (*ret).tableau[12][15]=0;
    (*ret).tableau[13][0]=0;    (*ret).tableau[13][1]=0;    (*ret).tableau[13][2]=1;    (*ret).tableau[13][3]=0;    (*ret).tableau[13][4]=0;    (*ret).tableau[13][5]=0;    (*ret).tableau[13][6]=0;    (*ret).tableau[13][7]=0;    (*ret).tableau[13][8]=0;    (*ret).tableau[13][9]=0;    (*ret).tableau[13][10]=0;    (*ret).tableau[13][11]=0;    (*ret).tableau[13][12]=0;    (*ret).tableau[13][13]=1;    (*ret).tableau[13][14]=0;    (*ret).tableau[13][15]=0;
    (*ret).tableau[14][0]=0;    (*ret).tableau[14][1]=0;    (*ret).tableau[14][2]=0;    (*ret).tableau[14][3]=1;    (*ret).tableau[14][4]=1;    (*ret).tableau[14][5]=0;    (*ret).tableau[14][6]=0;    (*ret).tableau[14][7]=0;    (*ret).tableau[14][8]=0;    (*ret).tableau[14][9]=0;    (*ret).tableau[14][10]=0;    (*ret).tableau[14][11]=1;    (*ret).tableau[14][12]=1;    (*ret).tableau[14][13]=0;    (*ret).tableau[14][14]=0;    (*ret).tableau[14][15]=0;
    (*ret).tableau[15][0]=0;    (*ret).tableau[15][1]=0;    (*ret).tableau[15][2]=0;    (*ret).tableau[15][3]=0;    (*ret).tableau[15][4]=0;    (*ret).tableau[15][5]=1;    (*ret).tableau[15][6]=1;    (*ret).tableau[15][7]=1;    (*ret).tableau[15][8]=1;    (*ret).tableau[15][9]=1;    (*ret).tableau[15][10]=1;    (*ret).tableau[15][11]=0;    (*ret).tableau[15][12]=0;    (*ret).tableau[15][13]=0;    (*ret).tableau[15][14]=0;    (*ret).tableau[15][15]=0;
    return ret;
}

matrice *BS_graphe(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=16;
    (*ret).tailleY=16;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;    (*ret).tableau[0][11]=0;    (*ret).tableau[0][12]=0;    (*ret).tableau[0][13]=0;    (*ret).tableau[0][14]=0;    (*ret).tableau[0][15]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;    (*ret).tableau[1][11]=0;    (*ret).tableau[1][12]=0;    (*ret).tableau[1][13]=0;    (*ret).tableau[1][14]=0;    (*ret).tableau[1][15]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=1;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;    (*ret).tableau[2][11]=0;    (*ret).tableau[2][12]=0;    (*ret).tableau[2][13]=0;    (*ret).tableau[2][14]=0;    (*ret).tableau[2][15]=0;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;    (*ret).tableau[3][11]=0;    (*ret).tableau[3][12]=0;    (*ret).tableau[3][13]=0;    (*ret).tableau[3][14]=0;    (*ret).tableau[3][15]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;    (*ret).tableau[4][11]=0;    (*ret).tableau[4][12]=0;    (*ret).tableau[4][13]=0;    (*ret).tableau[4][14]=0;    (*ret).tableau[4][15]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;    (*ret).tableau[5][11]=0;    (*ret).tableau[5][12]=0;    (*ret).tableau[5][13]=0;    (*ret).tableau[5][14]=0;    (*ret).tableau[5][15]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;    (*ret).tableau[6][11]=0;    (*ret).tableau[6][12]=0;    (*ret).tableau[6][13]=0;    (*ret).tableau[6][14]=0;    (*ret).tableau[6][15]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;    (*ret).tableau[7][11]=0;    (*ret).tableau[7][12]=0;    (*ret).tableau[7][13]=0;    (*ret).tableau[7][14]=0;    (*ret).tableau[7][15]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;    (*ret).tableau[8][11]=0;    (*ret).tableau[8][12]=0;    (*ret).tableau[8][13]=0;    (*ret).tableau[8][14]=0;    (*ret).tableau[8][15]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;    (*ret).tableau[9][11]=0;    (*ret).tableau[9][12]=0;    (*ret).tableau[9][13]=1;    (*ret).tableau[9][14]=0;    (*ret).tableau[9][15]=1;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=1;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;    (*ret).tableau[10][11]=0;    (*ret).tableau[10][12]=0;    (*ret).tableau[10][13]=0;    (*ret).tableau[10][14]=1;    (*ret).tableau[10][15]=0;
    (*ret).tableau[11][0]=0;    (*ret).tableau[11][1]=0;    (*ret).tableau[11][2]=1;    (*ret).tableau[11][3]=0;    (*ret).tableau[11][4]=0;    (*ret).tableau[11][5]=0;    (*ret).tableau[11][6]=0;    (*ret).tableau[11][7]=0;    (*ret).tableau[11][8]=0;    (*ret).tableau[11][9]=0;    (*ret).tableau[11][10]=0;    (*ret).tableau[11][11]=0;    (*ret).tableau[11][12]=0;    (*ret).tableau[11][13]=1;    (*ret).tableau[11][14]=0;    (*ret).tableau[11][15]=1;
    (*ret).tableau[12][0]=0;    (*ret).tableau[12][1]=0;    (*ret).tableau[12][2]=1;    (*ret).tableau[12][3]=0;    (*ret).tableau[12][4]=0;    (*ret).tableau[12][5]=0;    (*ret).tableau[12][6]=0;    (*ret).tableau[12][7]=0;    (*ret).tableau[12][8]=0;    (*ret).tableau[12][9]=0;    (*ret).tableau[12][10]=0;    (*ret).tableau[12][11]=0;    (*ret).tableau[12][12]=0;    (*ret).tableau[12][13]=0;    (*ret).tableau[12][14]=0;    (*ret).tableau[12][15]=0;
    (*ret).tableau[13][0]=0;    (*ret).tableau[13][1]=0;    (*ret).tableau[13][2]=1;    (*ret).tableau[13][3]=1;    (*ret).tableau[13][4]=1;    (*ret).tableau[13][5]=1;    (*ret).tableau[13][6]=1;    (*ret).tableau[13][7]=1;    (*ret).tableau[13][8]=1;    (*ret).tableau[13][9]=1;    (*ret).tableau[13][10]=1;    (*ret).tableau[13][11]=1;    (*ret).tableau[13][12]=1;    (*ret).tableau[13][13]=1;    (*ret).tableau[13][14]=1;    (*ret).tableau[13][15]=0;
    (*ret).tableau[14][0]=0;    (*ret).tableau[14][1]=0;    (*ret).tableau[14][2]=0;    (*ret).tableau[14][3]=0;    (*ret).tableau[14][4]=0;    (*ret).tableau[14][5]=0;    (*ret).tableau[14][6]=0;    (*ret).tableau[14][7]=0;    (*ret).tableau[14][8]=0;    (*ret).tableau[14][9]=0;    (*ret).tableau[14][10]=0;    (*ret).tableau[14][11]=0;    (*ret).tableau[14][12]=0;    (*ret).tableau[14][13]=0;    (*ret).tableau[14][14]=1;    (*ret).tableau[14][15]=0;
    (*ret).tableau[15][0]=0;    (*ret).tableau[15][1]=0;    (*ret).tableau[15][2]=0;    (*ret).tableau[15][3]=0;    (*ret).tableau[15][4]=0;    (*ret).tableau[15][5]=0;    (*ret).tableau[15][6]=0;    (*ret).tableau[15][7]=0;    (*ret).tableau[15][8]=0;    (*ret).tableau[15][9]=0;    (*ret).tableau[15][10]=0;    (*ret).tableau[15][11]=0;    (*ret).tableau[15][12]=0;    (*ret).tableau[15][13]=1;    (*ret).tableau[15][14]=0;    (*ret).tableau[15][15]=0;
    return ret;
}

matrice *BS_Train(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=1;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=1;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=1;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=1;    (*ret).tableau[2][7]=1;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=1;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=1;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=1;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

//Liste de chiffres arabes monospacé

matrice *BS_0(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=1;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=0;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=1;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;
    (*ret).tableau[4][0]=1;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;
    (*ret).tableau[5][0]=1;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;
    (*ret).tableau[6][0]=1;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;
    (*ret).tableau[7][0]=1;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;
    return ret;
}

matrice *BS_1(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;
    (*ret).tableau[8][0]=1;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=1;
    return ret;
}

matrice *BS_2(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=1;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=0;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;
    (*ret).tableau[7][0]=1;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;
    (*ret).tableau[8][0]=1;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=1;
    return ret;
}

matrice *BS_3(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=1;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=0;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;
    (*ret).tableau[7][0]=1;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;
    return ret;
}

matrice *BS_4(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=1;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=0;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=0;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;
    (*ret).tableau[4][0]=1;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;
    return ret;
}

matrice *BS_5(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=1;    (*ret).tableau[0][1]=1;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=1;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;
    (*ret).tableau[8][0]=1;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;
    return ret;
}

matrice *BS_6(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=1;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;
    (*ret).tableau[4][0]=1;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;
    (*ret).tableau[5][0]=1;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;
    (*ret).tableau[6][0]=1;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;
    (*ret).tableau[7][0]=1;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;
    return ret;
}

matrice *BS_7(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=1;    (*ret).tableau[0][1]=1;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=1;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;
    return ret;
}

matrice *BS_8(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=1;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=0;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=1;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;
    (*ret).tableau[5][0]=1;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;
    (*ret).tableau[6][0]=1;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;
    (*ret).tableau[7][0]=1;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;
    return ret;
}

matrice *BS_9(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleY=9;
    (*ret).tailleX=5;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=1;    (*ret).tableau[0][2]=1;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=0;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;
    (*ret).tableau[8][0]=1;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;
    return ret;
}

matrice *BS_na(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=5;
    (*ret).tailleY=9;
    (*ret).tableau[0][0]=1;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=1;    (*ret).tableau[0][4]=0;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=0;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;
    (*ret).tableau[8][0]=1;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=1;
    return ret;
}


void BS_displayChiffre(int x,int y,int num,int taille,long long int couleur){
    matrice* mmm;   //On utilisera une matrice que l'on ne connais pas encore
    switch(num){    //On remplacera mmm par la matrice qui correspond au chiffre que l'on veut écrire
        case 0:
            mmm = BS_0();
            break;
        case 1:
            mmm = BS_1();
            break;
        case 2:
            mmm = BS_2();
            break;
        case 3:
            mmm = BS_3();
            break;
        case 4:
            mmm = BS_4();
            break;
        case 5:
            mmm = BS_5();
            break;
        case 6:
            mmm = BS_6();
            break;
        case 7:
            mmm = BS_7();
            break;
        case 8:
            mmm = BS_8();
            break;
        case 9:
            mmm = BS_9();
            break;
        default:
            mmm = BS_na();
    }
    DisplayMatrix(x,y,mmm,taille,couleur);  //Une fois que l'on a la metrice que l'on souhaite on la dessine
}

void BS_displayChiffreClean(int x,int y,int num,int taille,long long int couleur,long long int couleurFond){
    matrice* mmm;
    switch(num){
        case 0:
            mmm = BS_0();
            break;
        case 1:
            mmm = BS_1();
            break;
        case 2:
            mmm = BS_2();
            break;
        case 3:
            mmm = BS_3();
            break;
        case 4:
            mmm = BS_4();
            break;
        case 5:
            mmm = BS_5();
            break;
        case 6:
            mmm = BS_6();
            break;
        case 7:
            mmm = BS_7();
            break;
        case 8:
            mmm = BS_8();
            break;
        case 9:
            mmm = BS_9();
            break;
        default:
            mmm = BS_na();
    }
    DisplayMatrixClean(x,y,mmm,taille,couleur,couleurFond); //Comme la fonction précédente mais on met un fond uni avant
}

void BS_displayChiffre10Clean(int x,int y,int num,int taille,long long int couleur,long long int couleurFond){
    int a = num/10;    //On récupre les dizaines de num
    int b = (num- a * 10);  //On récupère les unités qui restent
    lcdT.SetTextColor(couleurFond); //On fait le fond
    lcdT.FillRect(y,x,taille * 9,taille * 11);
    BS_displayChiffre(x,y,a,taille,couleur);    //On affiche à la suite les 3 nombres.
    BS_displayChiffre(x + 6 * taille,y,b,taille,couleur);
}

void BS_displayChiffre100Clean(int x,int y,int num,int taille,long long int couleur,long long int couleurFond){
    int a = num/100;    //On récupre les centaines de num
    int b = (num- a * 100)/10;  //On récupère les dizaines
    int c = num - a * 100 - b * 10; //On récupère les unités qui restent
    lcdT.SetTextColor(couleurFond); //On fait le fond
    lcdT.FillRect(y,x,taille * 9,taille * 17);
    BS_displayChiffre(x,y,a,taille,couleur);    //On affiche à la suite les 3 nombres.
    BS_displayChiffre(x + 6 * taille,y,b,taille,couleur);
    BS_displayChiffre(x + 12 * taille,y,c,taille,couleur);
}

//Symboles pour l'horloge

matrice *BS_dotdot(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=8;
    (*ret).tailleY=8;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;
    return ret;
}

matrice *BS_fleche(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=1;    (*ret).tableau[2][7]=1;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=1;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=1;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=1;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=1;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=1;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=1;
    (*ret).tableau[6][0]=1;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=1;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=1;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=1;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_cloche(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=22;
    (*ret).tailleY=22;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;    (*ret).tableau[0][11]=0;    (*ret).tableau[0][12]=0;    (*ret).tableau[0][13]=0;    (*ret).tableau[0][14]=0;    (*ret).tableau[0][15]=0;    (*ret).tableau[0][16]=0;    (*ret).tableau[0][17]=0;    (*ret).tableau[0][18]=0;    (*ret).tableau[0][19]=0;    (*ret).tableau[0][20]=0;    (*ret).tableau[0][21]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;    (*ret).tableau[1][11]=0;    (*ret).tableau[1][12]=0;    (*ret).tableau[1][13]=0;    (*ret).tableau[1][14]=0;    (*ret).tableau[1][15]=0;    (*ret).tableau[1][16]=0;    (*ret).tableau[1][17]=0;    (*ret).tableau[1][18]=0;    (*ret).tableau[1][19]=0;    (*ret).tableau[1][20]=0;    (*ret).tableau[1][21]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=1;    (*ret).tableau[2][9]=1;    (*ret).tableau[2][10]=1;    (*ret).tableau[2][11]=1;    (*ret).tableau[2][12]=1;    (*ret).tableau[2][13]=0;    (*ret).tableau[2][14]=0;    (*ret).tableau[2][15]=0;    (*ret).tableau[2][16]=0;    (*ret).tableau[2][17]=0;    (*ret).tableau[2][18]=0;    (*ret).tableau[2][19]=0;    (*ret).tableau[2][20]=0;    (*ret).tableau[2][21]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=1;    (*ret).tableau[3][7]=1;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=1;    (*ret).tableau[3][10]=1;    (*ret).tableau[3][11]=1;    (*ret).tableau[3][12]=1;    (*ret).tableau[3][13]=1;    (*ret).tableau[3][14]=1;    (*ret).tableau[3][15]=0;    (*ret).tableau[3][16]=0;    (*ret).tableau[3][17]=0;    (*ret).tableau[3][18]=0;    (*ret).tableau[3][19]=0;    (*ret).tableau[3][20]=0;    (*ret).tableau[3][21]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=1;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;    (*ret).tableau[4][11]=0;    (*ret).tableau[4][12]=1;    (*ret).tableau[4][13]=1;    (*ret).tableau[4][14]=1;    (*ret).tableau[4][15]=1;    (*ret).tableau[4][16]=0;    (*ret).tableau[4][17]=0;    (*ret).tableau[4][18]=0;    (*ret).tableau[4][19]=0;    (*ret).tableau[4][20]=0;    (*ret).tableau[4][21]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;    (*ret).tableau[5][11]=0;    (*ret).tableau[5][12]=0;    (*ret).tableau[5][13]=0;    (*ret).tableau[5][14]=1;    (*ret).tableau[5][15]=1;    (*ret).tableau[5][16]=1;    (*ret).tableau[5][17]=0;    (*ret).tableau[5][18]=0;    (*ret).tableau[5][19]=0;    (*ret).tableau[5][20]=0;    (*ret).tableau[5][21]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=1;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;    (*ret).tableau[6][11]=0;    (*ret).tableau[6][12]=0;    (*ret).tableau[6][13]=0;    (*ret).tableau[6][14]=1;    (*ret).tableau[6][15]=1;    (*ret).tableau[6][16]=1;    (*ret).tableau[6][17]=1;    (*ret).tableau[6][18]=0;    (*ret).tableau[6][19]=0;    (*ret).tableau[6][20]=0;    (*ret).tableau[6][21]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=1;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;    (*ret).tableau[7][11]=0;    (*ret).tableau[7][12]=0;    (*ret).tableau[7][13]=0;    (*ret).tableau[7][14]=0;    (*ret).tableau[7][15]=1;    (*ret).tableau[7][16]=1;    (*ret).tableau[7][17]=1;    (*ret).tableau[7][18]=0;    (*ret).tableau[7][19]=0;    (*ret).tableau[7][20]=0;    (*ret).tableau[7][21]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;    (*ret).tableau[8][11]=0;    (*ret).tableau[8][12]=0;    (*ret).tableau[8][13]=0;    (*ret).tableau[8][14]=0;    (*ret).tableau[8][15]=0;    (*ret).tableau[8][16]=1;    (*ret).tableau[8][17]=1;    (*ret).tableau[8][18]=0;    (*ret).tableau[8][19]=0;    (*ret).tableau[8][20]=0;    (*ret).tableau[8][21]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;    (*ret).tableau[9][11]=0;    (*ret).tableau[9][12]=0;    (*ret).tableau[9][13]=0;    (*ret).tableau[9][14]=0;    (*ret).tableau[9][15]=0;    (*ret).tableau[9][16]=1;    (*ret).tableau[9][17]=1;    (*ret).tableau[9][18]=0;    (*ret).tableau[9][19]=0;    (*ret).tableau[9][20]=0;    (*ret).tableau[9][21]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=1;    (*ret).tableau[10][4]=1;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;    (*ret).tableau[10][11]=0;    (*ret).tableau[10][12]=0;    (*ret).tableau[10][13]=0;    (*ret).tableau[10][14]=0;    (*ret).tableau[10][15]=0;    (*ret).tableau[10][16]=1;    (*ret).tableau[10][17]=1;    (*ret).tableau[10][18]=0;    (*ret).tableau[10][19]=0;    (*ret).tableau[10][20]=0;    (*ret).tableau[10][21]=0;
    (*ret).tableau[11][0]=0;    (*ret).tableau[11][1]=0;    (*ret).tableau[11][2]=1;    (*ret).tableau[11][3]=1;    (*ret).tableau[11][4]=1;    (*ret).tableau[11][5]=0;    (*ret).tableau[11][6]=0;    (*ret).tableau[11][7]=0;    (*ret).tableau[11][8]=0;    (*ret).tableau[11][9]=0;    (*ret).tableau[11][10]=0;    (*ret).tableau[11][11]=0;    (*ret).tableau[11][12]=0;    (*ret).tableau[11][13]=0;    (*ret).tableau[11][14]=0;    (*ret).tableau[11][15]=0;    (*ret).tableau[11][16]=1;    (*ret).tableau[11][17]=1;    (*ret).tableau[11][18]=1;    (*ret).tableau[11][19]=1;    (*ret).tableau[11][20]=0;    (*ret).tableau[11][21]=0;
    (*ret).tableau[12][0]=0;    (*ret).tableau[12][1]=1;    (*ret).tableau[12][2]=1;    (*ret).tableau[12][3]=1;    (*ret).tableau[12][4]=1;    (*ret).tableau[12][5]=0;    (*ret).tableau[12][6]=0;    (*ret).tableau[12][7]=0;    (*ret).tableau[12][8]=0;    (*ret).tableau[12][9]=0;    (*ret).tableau[12][10]=0;    (*ret).tableau[12][11]=0;    (*ret).tableau[12][12]=0;    (*ret).tableau[12][13]=0;    (*ret).tableau[12][14]=0;    (*ret).tableau[12][15]=0;    (*ret).tableau[12][16]=1;    (*ret).tableau[12][17]=1;    (*ret).tableau[12][18]=1;    (*ret).tableau[12][19]=1;    (*ret).tableau[12][20]=1;    (*ret).tableau[12][21]=0;
    (*ret).tableau[13][0]=1;    (*ret).tableau[13][1]=1;    (*ret).tableau[13][2]=1;    (*ret).tableau[13][3]=1;    (*ret).tableau[13][4]=0;    (*ret).tableau[13][5]=0;    (*ret).tableau[13][6]=0;    (*ret).tableau[13][7]=0;    (*ret).tableau[13][8]=0;    (*ret).tableau[13][9]=0;    (*ret).tableau[13][10]=0;    (*ret).tableau[13][11]=0;    (*ret).tableau[13][12]=0;    (*ret).tableau[13][13]=0;    (*ret).tableau[13][14]=0;    (*ret).tableau[13][15]=0;    (*ret).tableau[13][16]=0;    (*ret).tableau[13][17]=0;    (*ret).tableau[13][18]=1;    (*ret).tableau[13][19]=1;    (*ret).tableau[13][20]=1;    (*ret).tableau[13][21]=1;
    (*ret).tableau[14][0]=1;    (*ret).tableau[14][1]=1;    (*ret).tableau[14][2]=1;    (*ret).tableau[14][3]=0;    (*ret).tableau[14][4]=0;    (*ret).tableau[14][5]=0;    (*ret).tableau[14][6]=0;    (*ret).tableau[14][7]=0;    (*ret).tableau[14][8]=0;    (*ret).tableau[14][9]=0;    (*ret).tableau[14][10]=0;    (*ret).tableau[14][11]=0;    (*ret).tableau[14][12]=0;    (*ret).tableau[14][13]=0;    (*ret).tableau[14][14]=0;    (*ret).tableau[14][15]=0;    (*ret).tableau[14][16]=0;    (*ret).tableau[14][17]=0;    (*ret).tableau[14][18]=0;    (*ret).tableau[14][19]=1;    (*ret).tableau[14][20]=1;    (*ret).tableau[14][21]=1;
    (*ret).tableau[15][0]=1;    (*ret).tableau[15][1]=1;    (*ret).tableau[15][2]=1;    (*ret).tableau[15][3]=1;    (*ret).tableau[15][4]=1;    (*ret).tableau[15][5]=1;    (*ret).tableau[15][6]=1;    (*ret).tableau[15][7]=1;    (*ret).tableau[15][8]=1;    (*ret).tableau[15][9]=1;    (*ret).tableau[15][10]=1;    (*ret).tableau[15][11]=1;    (*ret).tableau[15][12]=1;    (*ret).tableau[15][13]=1;    (*ret).tableau[15][14]=1;    (*ret).tableau[15][15]=1;    (*ret).tableau[15][16]=1;    (*ret).tableau[15][17]=1;    (*ret).tableau[15][18]=1;    (*ret).tableau[15][19]=1;    (*ret).tableau[15][20]=1;    (*ret).tableau[15][21]=1;
    (*ret).tableau[16][0]=1;    (*ret).tableau[16][1]=1;    (*ret).tableau[16][2]=1;    (*ret).tableau[16][3]=1;    (*ret).tableau[16][4]=1;    (*ret).tableau[16][5]=1;    (*ret).tableau[16][6]=1;    (*ret).tableau[16][7]=1;    (*ret).tableau[16][8]=1;    (*ret).tableau[16][9]=1;    (*ret).tableau[16][10]=1;    (*ret).tableau[16][11]=1;    (*ret).tableau[16][12]=1;    (*ret).tableau[16][13]=1;    (*ret).tableau[16][14]=1;    (*ret).tableau[16][15]=1;    (*ret).tableau[16][16]=1;    (*ret).tableau[16][17]=1;    (*ret).tableau[16][18]=1;    (*ret).tableau[16][19]=1;    (*ret).tableau[16][20]=1;    (*ret).tableau[16][21]=1;
    (*ret).tableau[17][0]=0;    (*ret).tableau[17][1]=0;    (*ret).tableau[17][2]=0;    (*ret).tableau[17][3]=0;    (*ret).tableau[17][4]=0;    (*ret).tableau[17][5]=0;    (*ret).tableau[17][6]=1;    (*ret).tableau[17][7]=1;    (*ret).tableau[17][8]=0;    (*ret).tableau[17][9]=0;    (*ret).tableau[17][10]=0;    (*ret).tableau[17][11]=0;    (*ret).tableau[17][12]=0;    (*ret).tableau[17][13]=1;    (*ret).tableau[17][14]=1;    (*ret).tableau[17][15]=0;    (*ret).tableau[17][16]=0;    (*ret).tableau[17][17]=0;    (*ret).tableau[17][18]=0;    (*ret).tableau[17][19]=0;    (*ret).tableau[17][20]=0;    (*ret).tableau[17][21]=0;
    (*ret).tableau[18][0]=0;    (*ret).tableau[18][1]=0;    (*ret).tableau[18][2]=0;    (*ret).tableau[18][3]=0;    (*ret).tableau[18][4]=0;    (*ret).tableau[18][5]=0;    (*ret).tableau[18][6]=1;    (*ret).tableau[18][7]=1;    (*ret).tableau[18][8]=1;    (*ret).tableau[18][9]=0;    (*ret).tableau[18][10]=0;    (*ret).tableau[18][11]=0;    (*ret).tableau[18][12]=1;    (*ret).tableau[18][13]=1;    (*ret).tableau[18][14]=1;    (*ret).tableau[18][15]=0;    (*ret).tableau[18][16]=0;    (*ret).tableau[18][17]=0;    (*ret).tableau[18][18]=0;    (*ret).tableau[18][19]=0;    (*ret).tableau[18][20]=0;    (*ret).tableau[18][21]=0;
    (*ret).tableau[19][0]=0;    (*ret).tableau[19][1]=0;    (*ret).tableau[19][2]=0;    (*ret).tableau[19][3]=0;    (*ret).tableau[19][4]=0;    (*ret).tableau[19][5]=0;    (*ret).tableau[19][6]=1;    (*ret).tableau[19][7]=1;    (*ret).tableau[19][8]=1;    (*ret).tableau[19][9]=1;    (*ret).tableau[19][10]=1;    (*ret).tableau[19][11]=1;    (*ret).tableau[19][12]=1;    (*ret).tableau[19][13]=1;    (*ret).tableau[19][14]=1;    (*ret).tableau[19][15]=0;    (*ret).tableau[19][16]=0;    (*ret).tableau[19][17]=0;    (*ret).tableau[19][18]=0;    (*ret).tableau[19][19]=0;    (*ret).tableau[19][20]=0;    (*ret).tableau[19][21]=0;
    (*ret).tableau[20][0]=0;    (*ret).tableau[20][1]=0;    (*ret).tableau[20][2]=0;    (*ret).tableau[20][3]=0;    (*ret).tableau[20][4]=0;    (*ret).tableau[20][5]=0;    (*ret).tableau[20][6]=0;    (*ret).tableau[20][7]=0;    (*ret).tableau[20][8]=1;    (*ret).tableau[20][9]=1;    (*ret).tableau[20][10]=1;    (*ret).tableau[20][11]=1;    (*ret).tableau[20][12]=1;    (*ret).tableau[20][13]=0;    (*ret).tableau[20][14]=0;    (*ret).tableau[20][15]=0;    (*ret).tableau[20][16]=0;    (*ret).tableau[20][17]=0;    (*ret).tableau[20][18]=0;    (*ret).tableau[20][19]=0;    (*ret).tableau[20][20]=0;    (*ret).tableau[20][21]=0;
    (*ret).tableau[21][0]=0;    (*ret).tableau[21][1]=0;    (*ret).tableau[21][2]=0;    (*ret).tableau[21][3]=0;    (*ret).tableau[21][4]=0;    (*ret).tableau[21][5]=0;    (*ret).tableau[21][6]=0;    (*ret).tableau[21][7]=0;    (*ret).tableau[21][8]=0;    (*ret).tableau[21][9]=0;    (*ret).tableau[21][10]=0;    (*ret).tableau[21][11]=0;    (*ret).tableau[21][12]=0;    (*ret).tableau[21][13]=0;    (*ret).tableau[21][14]=0;    (*ret).tableau[21][15]=0;    (*ret).tableau[21][16]=0;    (*ret).tableau[21][17]=0;    (*ret).tableau[21][18]=0;    (*ret).tableau[21][19]=0;    (*ret).tableau[21][20]=0;    (*ret).tableau[21][21]=0;
    return ret;
}

//Symboles des éléments

matrice *BS_H(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=1;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=1;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=1;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_He(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Li(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=1;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Be(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_B(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=1;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=1;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=1;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=1;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_C(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=1;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=1;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_N(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=1;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=1;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=1;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=1;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_O(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=1;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=1;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=1;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_F(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=1;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=1;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ne(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Na(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Mg(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=1;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=1;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=1;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=1;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=1;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=1;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=1;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=1;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=1;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=1;    (*ret).tableau[10][8]=1;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Al(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=1;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=1;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Si(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=1;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=1;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=1;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=1;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_P(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=1;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=1;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_S(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=1;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=1;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=1;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Cl(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=1;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=1;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=1;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ar(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_K(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=1;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=1;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=1;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ca(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Sc(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=1;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ti(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=1;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_V(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=1;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=1;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=1;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=1;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=1;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Cr(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Mn(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=1;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Fe(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Co(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ni(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=1;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Cu(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Zn(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=1;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ga(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ge(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_As(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Se(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Br(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=1;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Kr(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=1;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=1;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Rb(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Sr(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Y(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=1;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=1;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=1;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=1;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Zr(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Nb(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=1;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=1;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Mo(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Tc(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ru(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Rh(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=1;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=1;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=1;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=1;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Pd(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=1;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=1;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ag(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=1;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=1;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=1;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=1;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=1;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=1;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=1;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=1;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=1;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=1;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=1;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=1;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=1;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=1;    (*ret).tableau[10][8]=1;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Cd(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=1;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=1;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_In(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=1;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=1;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=1;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Sn(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=1;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=1;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=1;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=1;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=1;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Sb(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=1;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=1;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=1;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=1;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=1;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=1;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=1;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Te(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=1;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=1;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=1;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_I(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=1;    (*ret).tableau[1][7]=1;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=0;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=0;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=0;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=1;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Xe(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=0;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=0;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=0;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=1;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=0;    (*ret).tableau[7][2]=1;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=1;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Cs(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=1;    (*ret).tableau[4][9]=1;    (*ret).tableau[4][10]=1;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=0;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=0;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=1;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=0;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=1;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ba(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=1;    (*ret).tableau[4][3]=1;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_La(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=0;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Ce(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=0;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=0;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=0;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=0;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=1;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=0;    (*ret).tableau[9][2]=1;    (*ret).tableau[9][3]=1;    (*ret).tableau[9][4]=1;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Pr(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=1;    (*ret).tableau[1][3]=1;    (*ret).tableau[1][4]=1;    (*ret).tableau[1][5]=0;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=0;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=0;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=0;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=0;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=0;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=1;    (*ret).tableau[5][3]=1;    (*ret).tableau[5][4]=1;    (*ret).tableau[5][5]=0;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=1;    (*ret).tableau[5][8]=0;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=0;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=1;    (*ret).tableau[6][9]=0;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=0;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=0;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=0;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=0;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=0;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=1;    (*ret).tableau[9][8]=0;    (*ret).tableau[9][9]=0;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}

matrice *BS_Nd(){
    matrice* ret = (matrice*) malloc(sizeof(matrice));
    (*ret).tailleX=11;
    (*ret).tailleY=11;
    (*ret).tableau[0][0]=0;    (*ret).tableau[0][1]=0;    (*ret).tableau[0][2]=0;    (*ret).tableau[0][3]=0;    (*ret).tableau[0][4]=0;    (*ret).tableau[0][5]=0;    (*ret).tableau[0][6]=0;    (*ret).tableau[0][7]=0;    (*ret).tableau[0][8]=0;    (*ret).tableau[0][9]=0;    (*ret).tableau[0][10]=0;
    (*ret).tableau[1][0]=0;    (*ret).tableau[1][1]=1;    (*ret).tableau[1][2]=0;    (*ret).tableau[1][3]=0;    (*ret).tableau[1][4]=0;    (*ret).tableau[1][5]=1;    (*ret).tableau[1][6]=0;    (*ret).tableau[1][7]=0;    (*ret).tableau[1][8]=0;    (*ret).tableau[1][9]=0;    (*ret).tableau[1][10]=0;
    (*ret).tableau[2][0]=0;    (*ret).tableau[2][1]=1;    (*ret).tableau[2][2]=1;    (*ret).tableau[2][3]=0;    (*ret).tableau[2][4]=0;    (*ret).tableau[2][5]=1;    (*ret).tableau[2][6]=0;    (*ret).tableau[2][7]=0;    (*ret).tableau[2][8]=0;    (*ret).tableau[2][9]=0;    (*ret).tableau[2][10]=0;
    (*ret).tableau[3][0]=0;    (*ret).tableau[3][1]=1;    (*ret).tableau[3][2]=0;    (*ret).tableau[3][3]=1;    (*ret).tableau[3][4]=0;    (*ret).tableau[3][5]=1;    (*ret).tableau[3][6]=0;    (*ret).tableau[3][7]=0;    (*ret).tableau[3][8]=0;    (*ret).tableau[3][9]=1;    (*ret).tableau[3][10]=0;
    (*ret).tableau[4][0]=0;    (*ret).tableau[4][1]=1;    (*ret).tableau[4][2]=0;    (*ret).tableau[4][3]=0;    (*ret).tableau[4][4]=1;    (*ret).tableau[4][5]=1;    (*ret).tableau[4][6]=0;    (*ret).tableau[4][7]=0;    (*ret).tableau[4][8]=0;    (*ret).tableau[4][9]=1;    (*ret).tableau[4][10]=0;
    (*ret).tableau[5][0]=0;    (*ret).tableau[5][1]=1;    (*ret).tableau[5][2]=0;    (*ret).tableau[5][3]=0;    (*ret).tableau[5][4]=0;    (*ret).tableau[5][5]=1;    (*ret).tableau[5][6]=0;    (*ret).tableau[5][7]=0;    (*ret).tableau[5][8]=1;    (*ret).tableau[5][9]=1;    (*ret).tableau[5][10]=0;
    (*ret).tableau[6][0]=0;    (*ret).tableau[6][1]=1;    (*ret).tableau[6][2]=0;    (*ret).tableau[6][3]=0;    (*ret).tableau[6][4]=0;    (*ret).tableau[6][5]=1;    (*ret).tableau[6][6]=0;    (*ret).tableau[6][7]=1;    (*ret).tableau[6][8]=0;    (*ret).tableau[6][9]=1;    (*ret).tableau[6][10]=0;
    (*ret).tableau[7][0]=0;    (*ret).tableau[7][1]=1;    (*ret).tableau[7][2]=0;    (*ret).tableau[7][3]=0;    (*ret).tableau[7][4]=0;    (*ret).tableau[7][5]=1;    (*ret).tableau[7][6]=0;    (*ret).tableau[7][7]=1;    (*ret).tableau[7][8]=0;    (*ret).tableau[7][9]=1;    (*ret).tableau[7][10]=0;
    (*ret).tableau[8][0]=0;    (*ret).tableau[8][1]=1;    (*ret).tableau[8][2]=0;    (*ret).tableau[8][3]=0;    (*ret).tableau[8][4]=0;    (*ret).tableau[8][5]=1;    (*ret).tableau[8][6]=0;    (*ret).tableau[8][7]=1;    (*ret).tableau[8][8]=0;    (*ret).tableau[8][9]=1;    (*ret).tableau[8][10]=0;
    (*ret).tableau[9][0]=0;    (*ret).tableau[9][1]=1;    (*ret).tableau[9][2]=0;    (*ret).tableau[9][3]=0;    (*ret).tableau[9][4]=0;    (*ret).tableau[9][5]=1;    (*ret).tableau[9][6]=0;    (*ret).tableau[9][7]=0;    (*ret).tableau[9][8]=1;    (*ret).tableau[9][9]=1;    (*ret).tableau[9][10]=0;
    (*ret).tableau[10][0]=0;    (*ret).tableau[10][1]=0;    (*ret).tableau[10][2]=0;    (*ret).tableau[10][3]=0;    (*ret).tableau[10][4]=0;    (*ret).tableau[10][5]=0;    (*ret).tableau[10][6]=0;    (*ret).tableau[10][7]=0;    (*ret).tableau[10][8]=0;    (*ret).tableau[10][9]=0;    (*ret).tableau[10][10]=0;
    return ret;
}


matrice *BS_ElemMinute(int elem){
    matrice *ret = (matrice*) malloc(sizeof(matrice));
    switch(elem){
        case 1 :
            ret=BS_H();
            break;
        case 2 :
            ret=BS_He();
            break;
        case 3 :
            ret=BS_Li();
            break;
        case 4 :
            ret=BS_Be();
            break;
        case 5 :
            ret=BS_B();
            break;
        case 6 :
            ret=BS_C();
            break;
        case 7 :
            ret=BS_N();
            break;
        case 8 :
            ret=BS_O();
            break;
        case 9 :
            ret=BS_F();
            break;
        case 10 :
            ret=BS_Ne();
            break;
        case 11 :
            ret=BS_Na();
            break;
        case 12 :
            ret=BS_Mg();
            break;
        case 13 :
            ret=BS_Al();
            break;
        case 14 :
            ret=BS_Si();
            break;
        case 15 :
            ret=BS_P();
            break;
        case 16 :
            ret=BS_S();
            break;
        case 17 :
            ret=BS_Cl();
            break;
        case 18 :
            ret=BS_Ar();
            break;
        case 19 :
            ret=BS_K();
            break;
        case 20 :
            ret=BS_Ca();
            break;
        case 21 :
            ret=BS_Sc();
            break;
        case 22 :
            ret=BS_Ti();
            break;
        case 23 :
            ret=BS_V();
            break;
        case 24 :
            ret=BS_Cr();
            break;
        case 25 :
            ret=BS_Mn();
            break;
        case 26 :
            ret=BS_Fe();
            break;
        case 27 :
            ret=BS_Co();
            break;
        case 28 :
            ret=BS_Ni();
            break;
        case 29 :
            ret=BS_Cu();
            break;
        case 30 :
            ret=BS_Zn();
            break;
        case 31 :
            ret=BS_Ga();
            break;
        case 32 :
            ret=BS_Ge();
            break;
        case 33 :
            ret=BS_As();
            break;
        case 34 :
            ret=BS_Se();
            break;
        case 35 :
            ret=BS_Br();
            break;
        case 36 :
            ret=BS_Kr();
            break;
        case 37 :
            ret=BS_Rb();
            break;
        case 38 :
            ret=BS_Sr();
            break;
        case 39 :
            ret=BS_Y();
            break;
        case 40 :
            ret=BS_Zr();
            break;
        case 41 :
            ret=BS_Nb();
            break;
        case 42 :
            ret=BS_Mo();
            break;
        case 43 :
            ret=BS_Tc();
            break;
        case 44 :
            ret=BS_Ru();
            break;
        case 45 :
            ret=BS_Rh();
            break;
        case 46 :
            ret=BS_Pd();
            break;
        case 47 :
            ret=BS_Ag();
            break;
        case 48 :
            ret=BS_Cd();
            break;
        case 49 :
            ret=BS_In();
            break;
        case 50 :
            ret=BS_Sn();
            break;
        case 51 :
            ret=BS_Sb();
            break;
        case 52 :
            ret=BS_Te();
            break;
        case 53 :
            ret=BS_I();
            break;
        case 54 :
            ret=BS_Xe();
            break;
        case 55 :
            ret=BS_Cs();
            break;
        case 56 :
            ret=BS_Ba();
            break;
        case 57 :
            ret=BS_La();
            break;
        case 58 :
            ret=BS_Ce();
            break;
        case 59 :
            ret=BS_Pr();
            break;
        default:
            ret=BS_Nd();
    }
    return ret;
}

matrice *BS_ElemHeure(int elem){
    matrice *ret = (matrice*) malloc(sizeof(matrice));
    switch(elem){
        case 1 :
            ret=BS_H();
            break;
        case 2 :
            ret=BS_He();
            break;
        case 3 :
            ret=BS_Li();
            break;
        case 4 :
            ret=BS_Be();
            break;
        case 5 :
            ret=BS_B();
            break;
        case 6 :
            ret=BS_C();
            break;
        case 7 :
            ret=BS_N();
            break;
        case 8 :
            ret=BS_O();
            break;
        case 9 :
            ret=BS_F();
            break;
        case 10 :
            ret=BS_Ne();
            break;
        case 11 :
            ret=BS_Na();
            break;
        case 12 :
            ret=BS_Mg();
            break;
        case 13 :
            ret=BS_Al();
            break;
        case 14 :
            ret=BS_Si();
            break;
        case 15 :
            ret=BS_P();
            break;
        case 16 :
            ret=BS_S();
            break;
        case 17 :
            ret=BS_Cl();
            break;
        case 18 :
            ret=BS_Ar();
            break;
        case 19 :
            ret=BS_K();
            break;
        case 20 :
            ret=BS_Ca();
            break;
        case 21 :
            ret=BS_Sc();
            break;
        case 22 :
            ret=BS_Ti();
            break;
        case 23 :
            ret=BS_V();
            break;
        default:
            ret=BS_Cr();
    }
    return ret;
}

