#include "Tick.h"

int GLOBAL_VALEUR_TICK=0; //Valeur facile d'accès à incrémanter grâce au ticker
Ticker timer; //
AnalogOut pinHP(PA_5); //Pin pour le reveil
Ticker son; //son utile pour l'alarme
int GLOBAL_BOOL_ALARME=0;
//extern Serial pc;

void T_incermment(){
    GLOBAL_VALEUR_TICK++;
}

int T_checkValue(){
    if(GLOBAL_VALEUR_TICK){
        GLOBAL_VALEUR_TICK--;
        return 1;
    }else{
        return 0;
    }
}

void T_initialise(int tempsS){
    timer.attach(&T_incermment,tempsS);
    son.attach(&T_sendSon,0.5);
}

void T_test(){
    GLOBAL_VALEUR_TICK=0;
    timer.attach(&T_incermment,2);
    while(1){
        BS_displayChiffre100Clean(35,25,GLOBAL_VALEUR_TICK,5,LCD_COLOR_RED,LCD_COLOR_WHITE);
        wait(0.1);
    }
}

void T_sendSon(){
    if(GLOBAL_BOOL_ALARME){
        const double pi = 3.141592653589793238462;
        const double amplitude = 5.5f;
        const double offset = 65535/2;
        double rads = 0.0;
        uint16_t sample = 0;
        //pc.printf("entree dans la boucle\n");
        for (int i = 0; i < 12000; i++) {
            rads = (pi * i) / 180.0f;
            sample = (uint16_t)(amplitude * (offset * (cos(rads + pi))) + offset);
            pinHP.write_u16(sample);
            
        }
        //pc.printf("sortie de la boucle\n");
    }
}

