#include "Rot.h"
#include "alarme.h"

int CR_readPins(void){    
    DigitalIn pin1(PD_4); 
    DigitalIn pin2(PB_4);
    DigitalIn pin3(PB_7);
    DigitalIn pin4(PC_3);
    DigitalIn pin5(PC_8);
    DigitalIn pin6(PC_11);
    DigitalIn pin7(PC_12);
    DigitalIn pin8(PC_13);
    int decimalOutput=pin8.read();  //On va lire l'information donnée par chacune des pattes du composant et on écrit ça dans un bit d'un nombre pour connaitre la position du codeur.
    decimalOutput=decimalOutput<<1;
    decimalOutput=decimalOutput+pin7.read();
    decimalOutput=decimalOutput<<1;
    decimalOutput=decimalOutput+pin6.read();
    decimalOutput=decimalOutput<<1;
    decimalOutput=decimalOutput+pin5.read();
    decimalOutput=decimalOutput<<1;
    decimalOutput=decimalOutput+pin4.read();
    decimalOutput=decimalOutput<<1;
    decimalOutput=decimalOutput+pin3.read();
    decimalOutput=decimalOutput<<1;
    decimalOutput=decimalOutput+pin2.read();
    decimalOutput=decimalOutput<<1;
    decimalOutput=decimalOutput+pin1.read();
    return decimalOutput;
}

int CR_position(int decimalOutput){
    int position=0;
    switch(decimalOutput){  //Il faut ensuite transformer ce nombre en une quelque chose de lisible. Les différents cas qui suivent viennent de la documantation du composant.
        case 127 :
            position=0;
            break;
        case 63 :
            position=1;
            break;
        case 62 :
            position=2;
            break;
        case 58 :
            position=3;
            break;
        case 56 :
            position=4;
            break;
        case 184 :
            position=5;
            break;
        case 152 :
            position=6;
            break;
        case 24 :
            position=7;
            break;
        case 8 :
            position=8;
            break;
        case 72 :
            position=9;
            break;
        case 73 :
            position=10;
            break;
        case 77 :
            position=11;
            break;
        case 79 :
            position=12;
            break;
        case 15 :
            position=13;
            break;
        case 47 :
            position=14;
            break;
        case 175 :
            position=15;
            break;
        case 191 :
            position=16;
            break;
        case 159 :
            position=17;
            break;
        case 31 :
            position=18;
            break;
        case 29 :
            position=19;
            break;
        case 28 :
            position=20;
            break;
        case 92 :
            position=21;
            break;
        case 76 :
            position=22;
            break;
        case 12 :
            position=23;
            break;
        case 4 :
            position=24;
            break;
        case 36 :
            position=25;
            break;
        case 164 :
            position=26;
            break;
        case 166 :
            position=27;
            break;
        case 167 :
            position=28;
            break;
        case 135 :
            position=29;
            break;
        case 151 :
            position=30;
            break;
        case 215 :
            position=31;
            break;
        case 223 :
            position=32;
            break;
        case 207 :
            position=33;
            break;
        case 143 :
            position=34;
            break;
        case 142 :
            position=35;
            break;
        case 14 :
            position=36;
            break;
        case 46 :
            position=37;
            break;
        case 38 :
            position=38;
            break;
        case 6 :
            position=39;
            break;
        case 2 :
            position=40;
            break;
        case 18 :
            position=41;
            break;
        case 82 :
            position=42;
            break;
        case 83 :
            position=43;
            break;
        case 211 :
            position=44;
            break;
        case 195 :
            position=45;
            break;
        case 203 :
            position=46;
            break;
        case 235 :
            position=47;
            break;
        case 239 :
            position=48;
            break;
        case 231 :
            position=49;
            break;
        case 199 :
            position=50;
            break;
        case 71 :
            position=51;
            break;
        case 7 :
            position=52;
            break;
        case 23 :
            position=53;
            break;
        case 19 :
            position=54;
            break;
        case 3 :
            position=55;
            break;
        case 1 :
            position=56;
            break;
        case 9 :
            position=57;
            break;
        case 41 :
            position=58;
            break;
        case 169 :
            position=59;
            break;
        case 233 :
            position=60;
            break;
        case 225 :
            position=61;
            break;
        case 229 :
            position=62;
            break;
        case 245 :
            position=63;
            break;
        case 247 :
            position=64;
            break;
        case 243 :
            position=65;
            break;
        case 227 :
            position=66;
            break;
        case 163 :
            position=67;
            break;
        case 131 :
            position=68;
            break;
        case 139 :
            position=69;
            break;
        case 137 :
            position=70;
            break;
        case 129 :
            position=71;
            break;
        case 128 :
            position=72;
            break;
        case 132 :
            position=73;
            break;
        case 148 :
            position=74;
            break;
        case 212 :
            position=75;
            break;
        case 244 :
            position=76;
            break;
        case 240 :
            position=77;
            break;
        case 242 :
            position=78;
            break;
        case 250 :
            position=79;
            break;
        case 251 :
            position=80;
            break;
        case 249 :
            position=81;
            break;
        case 241 :
            position=82;
            break;
        case 209 :
            position=83;
            break;
        case 193 :
            position=84;
            break;
        case 197 :
            position=85;
            break;
        case 196 :
            position=86;
            break;
        case 192 :
            position=87;
            break;
        case 64 :
            position=88;
            break;
        case 66 :
            position=89;
            break;
        case 74 :
            position=90;
            break;
        case 106 :
            position=91;
            break;
        case 122 :
            position=92;
            break;
        case 120 :
            position=93;
            break;
        case 121 :
            position=94;
            break;
        case 125 :
            position=95;
            break;
        case 253 :
            position=96;
            break;
        case 252 :
            position=97;
            break;
        case 248 :
            position=98;
            break;
        case 232 :
            position=99;
            break;
        case 224 :
            position=100;
            break;
        case 226 :
            position=101;
            break;
        case 98 :
            position=102;
            break;
        case 96 :
            position=103;
            break;
        case 32 :
            position=104;
            break;
        case 33 :
            position=105;
            break;
        case 37 :
            position=106;
            break;
        case 53 :
            position=107;
            break;
        case 61 :
            position=108;
            break;
        case 60 :
            position=109;
            break;
        case 188 :
            position=110;
            break;
        case 190 :
            position=111;
            break;
        case 254 :
            position=112;
            break;
        case 126 :
            position=113;
            break;
        case 124 :
            position=114;
            break;
        case 116 :
            position=115;
            break;
        case 112 :
            position=116;
            break;
        case 113 :
            position=117;
            break;
        case 49 :
            position=118;
            break;
        case 48 :
            position=119;
            break;
        case 16 :
            position=120;
            break;
        case 144 :
            position=121;
            break;
        case 146 :
            position=122;
            break;
        case 154 :
            position=123;
            break;
        case 158 :
            position=124;
            break;
        case 30 :
            position=125;
            break;
        case 94 :
            position=126;
            break;
        case 95 :
            position=127;
            break;
        default :
            position=-999;
    }
    return position;
}

int CR_donneSelection(int position){
    return position/(128/(NOMBREDALARMES)); //Perme de faire en sorte que position soit le numéro d'une alarle ou un de plus et dans ce cas on ne pointe rien
}
    
void CR_test(void){
    LCD_DISCO_F429ZI lcdTemp;
    lcdTemp.Clear(0xFFFFFFFF);
    DisplayMatrix(0,0,BS_0(),1,LCD_COLOR_BLACK);
    DisplayMatrix(50,50,BS_Train(),8,LCD_COLOR_RED);
    DisplayMatrix(100,100,BS_1(),1,LCD_COLOR_YELLOW);
    DisplayMatrix(150,150,BS_1(),1,LCD_COLOR_YELLOW);
    wait(0.2);
    lcdTemp.Clear(0xFFFFFFFF);
    BS_displayChiffre(150,150,0,5,LCD_COLOR_BLUE);
    wait(0.2);
    lcdTemp.Clear(0xFFFFFFFF);
    
    while(1){
        int selection=CR_donneSelection(CR_position(CR_readPins()));
        BS_displayChiffreClean(150,150,selection,4,LCD_COLOR_BLUE,0xFFFFFFFF);
        BS_displayChiffre100Clean(150,100,CR_position(CR_readPins()),4,LCD_COLOR_BLUE,0xFFFFFFFF);
        BS_displayChiffre100Clean(150,50,CR_readPins(),4,LCD_COLOR_BLUE,0xFFFFFFFF);
        wait(0.05);
        
     }
}
