# include "alarme.h"

DigitalIn pinTgAl(PE_6); 
DigitalIn pinSeAl(PE_5);
DigitalOut pinAlarme(PG_13);
extern int GLOBAL_BOOL_ALARME; //booléen de gestion du son

void A_initAlarmes(STalarmes* all){
    all->ListeAlarmes = (temps*) malloc(sizeof(temps) * NOMBREDALARMES);
    for(int i=0;i<NOMBREDALARMES;i++){
        (all->ListeAlarmes+i)->heure = 0;
        (all->ListeAlarmes+i)->minute = 0;
        all->ListeActivation[i] = 0;
    }
}

void A_DisplayAlarmes(STalarmes* alarmesPNT){
    STalarmes alarmes = *alarmesPNT;
    int positionYinit = 5;
    int positionYIncrement = 25;
    int alarmeTaille = 1;
    int positionXinit = 10;
    for(int i=0;i<NOMBREDALARMES;i++){
        if(alarmes.positionCurseur==i){
            DisplayMatrix(positionXinit,positionYinit + positionYIncrement * i,BS_fleche(),alarmeTaille * 2,COULEUR_FLECHE);
        }else{
            DisplayMatrix(positionXinit,positionYinit + positionYIncrement * i,BS_fleche(),alarmeTaille * 2,COULEUR_FOND);
        }
        if(alarmes.ListeActivation[i]){
            DisplayMatrix(positionXinit + alarmeTaille * 26,positionYinit + positionYIncrement * i,BS_cloche(),alarmeTaille,COULEUR_ACTIVE);
        }else{
            DisplayMatrix(positionXinit + alarmeTaille * 26,positionYinit + positionYIncrement * i,BS_cloche(),alarmeTaille,COULEUR_OFF);
        }
        H_afficheHorlogeElemClean(*(alarmes.ListeAlarmes + i),positionXinit + alarmeTaille * 54,positionYinit + positionYIncrement * i,alarmeTaille * 2,COULEUR_HEURE_ALARME,COULEUR_FOND);
    }
}

void A_DisplayFleche(STalarmes* alarmesPNT){
    int positionYinit = 5;
    int positionYIncrement = 25;
    int alarmeTaille = 1;
    int positionXinit = 10;
    for(int i=0;i<NOMBREDALARMES;i++){
        if(alarmesPNT->positionCurseur==i){
            DisplayMatrix(positionXinit,positionYinit + positionYIncrement * i,BS_fleche(),alarmeTaille * 2,COULEUR_FLECHE);
        }else{
            DisplayMatrix(positionXinit,positionYinit + positionYIncrement * i,BS_fleche(),alarmeTaille * 2,COULEUR_FOND);
        }
    }
}

void A_getSelection(STalarmes* alarmesPNT){
    alarmesPNT->positionCurseur=CR_donneSelection(CR_position(CR_readPins()));
}

void A_toogleAlarme(STalarmes* alarmesPNT){
    if(pinTgAl.read() && alarmesPNT->positionCurseur < NOMBREDALARMES){
        while(pinTgAl.read()){
            ;
        }
    *(alarmesPNT->ListeActivation + alarmesPNT->positionCurseur)=!*(alarmesPNT->ListeActivation + alarmesPNT->positionCurseur);
    A_DisplayAlarmes(alarmesPNT);
    }
}

void A_setAlarme(STalarmes* alarmesPNT){
    if(pinSeAl.read() && alarmesPNT->positionCurseur < NOMBREDALARMES){
        while(pinSeAl.read()){
            ;
        }
    int positionYinit = 5;
    int positionYIncrement = 25;
    int alarmeTaille = 1;
    int positionXinit = 10;
    H_reglage(alarmesPNT->ListeAlarmes + alarmesPNT->positionCurseur,positionXinit + alarmeTaille * 54,positionYinit + positionYIncrement * alarmesPNT->positionCurseur,alarmeTaille * 2,COULEUR_HEURE_ALARME_MOD,COULEUR_FOND);
    A_DisplayAlarmes(alarmesPNT);
    }    
}

void A_checkAlarmes(STalarmes* alarmesPNT,temps* maintenant){
    int isOn=0; //booléen pour test l'activation d'une alarme.
    for(int i=0;i<NOMBREDALARMES;i++){
        if(*(alarmesPNT->ListeActivation + i) && (alarmesPNT->ListeAlarmes + i)->heure==maintenant->heure && (alarmesPNT->ListeAlarmes + i)->minute==maintenant->minute){
            isOn=1;
            break;
        }
    }
    pinAlarme=isOn;
    GLOBAL_BOOL_ALARME=isOn;
}
            

void A_test(){
    STalarmes alarmes;
    A_initAlarmes(&alarmes);
    clean();
    A_DisplayAlarmes(&alarmes);
    alarmes.positionCurseur=2;
    *(alarmes.ListeActivation+3)=1;
    (alarmes.ListeAlarmes+4)->minute=23;
    (alarmes.ListeAlarmes+4)->heure=17;
    wait(0.5);
    while(1){
        //clean();
        //wait(0.05);
        A_getSelection(&alarmes);
        A_toogleAlarme(&alarmes);
        A_setAlarme(&alarmes);
        A_DisplayFleche(&alarmes);
        //H_toogleElem();
        wait(0.15);
    }
}
