#include "mbed.h"
#include "rtos.h"
#include "ModbusSlave232.h" //see readme
#include "millis.h" //see readme
#include "ios.h"
#include "max6675.h"
ModbusSlave232 mbs; // Create new mbs instance

SPI spi(PB_5, PB_4, PB_3); // MOSI, MISO, SCLK
max6675 max(spi,PB_10);



Ticker seg,media ;

// Slave registersr
enum {
    MB_0,   // temperatura
    MB_1,   // tempo restante
    MB_2,   // setpoin temperatura
    MB_3,   // aquecimento bit5 manual/auto bit 4 liga/deli(manual) bit0estado
    MB_4,   // set temp1
    MB_5,   // set temp2
    MB_6,   // set temp3
    MB_7,   // set temp4
    MB_8,   // set temp5 fervura
    MB_9,   // set tempo 1
    MB_10,   // set tempo 2
    MB_11,   // set tempo 3
    MB_12,   // set tempo 4
    MB_13,   // set tempo 5 fervura
    MB_14,   //pwm
    MB_15,   //
    MB_16,   // bomba
    MB_17,   //
    MB_18,   //adiantar
    MB_19,   //ok
    MB_20,
    MB_21,
    MB_REGS // Dummy register. using 0 offset to keep size of array
};
//Prototipos
void cozimento(void);
void PID();
void segs();
void passagem_zero();
void atualiza(void);
void leitura(void);
void media_temp();
// variaveis Globais


float Kp=5.5, Ki=0.5, Kd=0.1, propo, integ, deriv,medida, setpoint[6], valor_medido, erro, erro_ant, pwm,temperatura, setpointAtual, periodo;
 int regs[MB_REGS], etapa, minetapa[6], bomba, tempoEtapa, cont1, cont2, cont3, aquecimento;



int main()
{
    const unsigned char SLAVE = 1;
    const long BAUD = 9600;
    const unsigned PARITY = 'n';
    seg.attach(&segs, 1.0);
    media.attach(&media_temp, 0.05);
    etapa=0;;
    res.period(5.f);

    startMillis(); // milliseconds (arduino like)

    mbs.configure(SLAVE, BAUD, PARITY);



    //test values (updatable)


    while (true) { //main thread
    if(aquecimento){                                        //se aquecimento estiver ligado periodo do duty cycle sera 1 div pwm
        periodo=1.0f/pwm;
        res.write(periodo);
        }
        
    if(!aquecimento)res.write(0.0f);                        // se aquecimento estiver deligado duty sera 0
        
        
        
        atualiza();                                         // atualiza holdregistres
        
        bombaOUT=bomba;
        
        
        
        
        
        switch(etapa){
            case 1:
            {tempoEtapa=minetapa[0];
            setpointAtual=setpoint[0];
  }          break;
            
            case 2:
            {tempoEtapa=minetapa[1];
            setpointAtual=setpoint[1];
  }          break;
  
  
            case 3:
            {tempoEtapa=minetapa[2];
            setpointAtual=setpoint[2];
  }          break;
            
            
            
            
            }


        mbs.update(regs, MB_REGS); // Pass current register values to mbs



   


    }

}
void atualiza()
{


}
void leitura()
{
    int conta;
    float cache;
    cache+=max.read_temp();
    conta++;
        if(conta>19){
            valor_medido=cache/conta;
            cache=0;
            conta=0;}



}
void PID()
{
    erro= setpointAtual - valor_medido;
    propo=erro*Kp;
    integ+=(erro*Ki);
    deriv=(erro-erro_ant)*Kd;
    erro_ant=erro;
    pwm=propo+integ+deriv;
    if(pwm>=100)pwm=100;
    else if(pwm<=0)pwm=0;

}










void segs (void)
{

    cont1++;
    cont2++;
    cont3++;

}





void media_temp(void)
{
    int contador;
    float cache;

    cache+=max.read_temp();
    contador++;
    if(contador>=20) {
        temperatura =cache/contador;
        contador=0;
        cache=0;
    }
}
