#include "mbed.h"
////////// motor (window) //////////
DigitalOut M1_a(A1);
DigitalOut M1_b(A2);
PwmOut M1_en(D3);
////////// motor (blind) //////////
DigitalOut M2_a(A3);
DigitalOut M2_b(A4);
PwmOut M2_en(D4);

int motor1_state;
int motor2_state;
int window_state;
int blind_state;


void motor1Stop();
void motor1CW(float speed);
void motor1CCW(float speed);

void motor2Stop();
void motor2CW(float speed);
void motor2CCW(float speed);




void motor1CW(float speed)
{
if(window_state==0)
{
motor1_state=1;
window_state=1;
M1_a=1;
M1_b=0;
M1_en.write((speed/100));
}
int i ;
for(i=0; i<11000000;i++){ }
motor1Stop();
}

void motor1CCW(float speed)
{
if(window_state==1)
{
motor1_state=0;
window_state=0;
M1_a=0;
M1_b=1;
M1_en.write((speed/100));
}
int i ;
for(i=0; i<11000000;i++){ }
motor1Stop();
}

void motor1Stop()
{
    
M1_a=0;
M1_b=0;
motor1_state=2;
}
void motor2CW(float speed)
{
if(blind_state==0)
{
motor2_state=1;
blind_state=1;
M2_a=1;
M2_b=0;
M2_en.write((speed/100));
}
int i ;
for(i=0; i<18000000;i++){ }
motor2Stop();
}

void motor2CCW(float speed)
{
if(blind_state==1)
{
motor2_state=0;
blind_state=0;
M2_a=0;
M2_b=1;
}
int i ;
for(i=0; i<18000000;i++){ }
motor2Stop();

}

void motor2Stop()
{
M2_a=0;
M2_b=0;
motor2_state=2;
}