#include "mbed.h"
#include "init_pin.h"
#include"Motorcontrol.h"

PwmOut pwmRed(D0);
PwmOut pwmGreen(D1);
PwmOut pwmBlue(D2);
uint8_t cdsCount;
AnalogIn CDS(A0);

extern int firstCycle;
float const variation = 0.00392;  
float red_value;
float green_value;
float blue_value;
extern int AutoMode;
extern int blind_state;
int cds_state;
int led_state;

void pwmLed()
{
   
    float cdsData;
    cdsData = CDS.read();   
    if (AutoMode==1)
    {
       
            
        if(cdsData<0.7f)
        {
            if(cdsCount<5)
            {
                cdsCount++;
            }
            pwmRed.write(0);     
            pwmGreen.write(0);  
            pwmBlue.write(0);
            cds_state=1;
        }
       else 
        {   
            if(cdsCount>0)
            {
              cdsCount--;
            }
            pwmRed.write(red_value);     
            pwmGreen.write(green_value);  
            pwmBlue.write(blue_value); 
            cds_state=0;
        }
        
    if((AutoMode==1)&&(blind_state==1)&&(cdsCount==5))
     {
        motor2CCW(10); // close
        
     }
    if((AutoMode==1)&&(blind_state==0)&&(cdsCount==0))
     {
        motor2CW(10); // Open
       
     }  
        
 
    }
    else 
    { 
      if(cdsData<0.7f)
        {
           cds_state=1;
        }
       else 
        {   
          cds_state=0;
        }
        pwmRed.write(red_value);     
        pwmGreen.write(green_value);  
        pwmBlue.write(blue_value);  
     
    }    
   
}   
void setRGB(float Red,float Green,float Blue,int led_info)
{
      if(firstCycle==1)
    {
        red_value=255;
        green_value=255;
        blue_value=255;
        cds_state=0;
        led_state=0; 
             
    }  

    if (led_info ==0) // led off
    {
        red_value =0;
        blue_value =0;
        green_value =0;
        led_state=0;
    }
    else if(led_info ==1) // led on
    {
        red_value = Red*variation;
        blue_value = Blue*variation;
        green_value = Green*variation;
        led_state=1;
    }
    
    if((led_info ==2)||(AutoMode==1)) //user input value
    {
        red_value = Red*variation;
        blue_value = Blue*variation;
        green_value = Green*variation;
        led_state=2;
    }
    
    pwmLed();
    
}


