// -*- coding: utf-8 -*-
/**
 @file      main.cpp
 @brief     Sample for "GPS_INT" library
 
 @author    D.Nakayama
 @version   1.0
 @date      2018-07-12  D.Nakayama  Written for C++/mbed.
 
 
 @see 
 Copyright (C) 2018 D.Nakayama.
 Released under the MIT license.
 http://opensource.org/licenses/mit-license.php
 using device Nucleo-F401RE and GMS7-CR6
*/

#include "mbed.h"
#include "GPS_INT.h"
#include "MODSERIAL.h"
#include "SDFileSystem.h"

MODSERIAL pc(USBTX, USBRX); // tx, rx 
GPS_INT gps(p9, p10);   // tx, rx
SDFileSystem sd(p5, p6, p7, p8, "sd");

//Init Serial port and LSM9DS1 chip
void setup()
{
    // Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    uint16_t status = imu.begin();

    //Make sure communication is working
    pc.printf("LSM9DS1 WHO_AM_I's returned: 0x%X\r\n", status);
    pc.printf("Should be 0x683D\r\n");
    
int main() {
    printf("Hello World!\n");
    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
        }
    setup();  //Setup sensor and Serial
    pc.printf("------ LSM9DS1 Demo -----------\r\n");

    while(1) {
        if(gps.location_is_update()){
            printf("UTC       :%04d/%02d/%02d %02d:%02d:%02d\n",gps.t.tm_year + 1900, gps.t.tm_mon + 1, gps.t.tm_mday, gps.t.tm_hour, gps.t.tm_min, gps.t.tm_sec);
            printf("longitude :%f\n",gps.lon);
            printf("latitude  :%f\n",gps.lat);
            printf("PDOP      :%.1f\n",gps.PDOP);
            printf("HDOP      :%.1f\n",gps.HDOP);
            printf("VDOP      :%.1f\n",gps.VDOP);
            printf("lock      :%d\n",gps.lock);
            printf("n_sat     :%d\n",gps.n_sat);
            printf("h_see     :%.1f\n",gps.h_see);
            printf("h_geo     :%.1f\n",gps.h_geo);
            printf("\n");
                pc.printf("Goodbye World!\n");
    }
           fclose(fp);
}
        }
    }
}
