#if !FEATURE_LWIP 
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "module_for_all.h"

#define PORT 8080

#define IP1        "192.168.20.101"
#define IP2        "192.168.20.102"
#define IP3        "192.168.20.103"
#define IP4        "192.168.20.104"
#define GATEWAY    "192.168.20.1"
#define MASK       "255.255.255.0"

const char* ip = 0;
const char* mac = 0;
Thread threadMain00;
DataStorage ds_manager("");

//DigitalIn  IP_Select2(PG_2);

//DigitalIn  Test_Mode(PC_14);

NetworkManager  net_manager(IP1, GATEWAY, MASK, PORT);
RestAPI_Manager restAPI_manager(&ds_manager, &threadMain00, IP1, "1");

//NetworkManager  net_manager();
//RestAPI_Manager restAPI_manager();

bool EventLoop() {
    while (true) {
        printf("$$ EventLoop New\r\n");
        
        Thread threadMain01;
        restAPI_manager.changeThread(&threadMain01);
        
        printf("$$ EventLoop Change Thread\r\n");
        
        LED_NetWait();
        
        printf("$$ EventLoop Waiting\r\n");
        
        net_manager.AcceptEvent();
        //printf("$$ EventLoop run Response\r\n");
        LED_NetProcess();
        
        std::string http_method = net_manager.getHttpMethod();
        std::string api_command = net_manager.getApiCommand();
        
        std::string response = restAPI_manager.runCommand(http_method, api_command);

        net_manager.SendResponseEvent(response);
        printf("$$ EventLoop Finish\r\n");
    }
    
    //printf("$$ EventLoop ALL Finish\r\n");
    return false;
}

/* Main function */
int main(){
    
    DigitalIn  IP_Select1(PD_7);
    DigitalIn  IP_Select2(PD_6);
    
    //DigitalIn  IP_Select21(PC_15);
    //DigitalIn  IP_Select22(PH_1);
    
    printf("mbed Power Start\r\n");
    LED_PowerStart();
    
    /*if (IP_Select2.read() == 1){
        net_manager.SetConfig(IP2, GATEWAY, MASK, PORT);
        restAPI_manager.SetConfig(IP2, "2");
        printf("mbed 02 Start\r\n");

    } else {
        net_manager.SetConfig(IP1, GATEWAY, MASK, PORT);
        restAPI_manager.SetConfig(IP1, "1");
        printf("mbed 01 Start\r\n");
    }*/
    
    int ipSelect = 1;
    
    if (IP_Select1.read() == 1){
        ipSelect += 1;
    }
    
    if (IP_Select2.read() == 1){
        ipSelect += 2;
    }
    
    char* tmp_IP = 0;
    
    switch(ipSelect) {
        case 1: 
            tmp_IP = IP1;
            break;
        case 2: 
            tmp_IP = IP2;
            break;
        case 3: 
            tmp_IP = IP3;
            break;
        case 4: 
            tmp_IP = IP4;
            break;
    }

    std::string tmp_IP_s = intToString(ipSelect);

    
    net_manager.SetConfig(tmp_IP, GATEWAY, MASK, PORT);
    restAPI_manager.SetConfig(tmp_IP, tmp_IP_s);
    
    printf("mbed %d Start\r\n", ipSelect);
    
    wait(1);
    
    /*int kk = 0;
    while(1){
        if (!net_manager.ServerInit()){
            break;
        }
        wait(4);
        kk++;
        printf("## again %d n\r\n", kk);
    }*/
    
    net_manager.ServerInit();
    printf("ServerInit\r\n");
    
    if (net_manager.OpenServer()) return 0;
    printf("OpenServer\r\n");
    
    if (net_manager.BindPort()) return 0;
    printf("BindPort\r\n");
    
    if (net_manager.ListenConnections()) return 0;
    printf("ListenConnections\r\n");
    
    if (EventLoop()) {
        return 0;
    }
}