#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"

#include <stdio.h>
#include <iostream>
#include <string.h>

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY ""                                     \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Hello ! mbed</h1>" "\r\n"                              \
"      <p>It works ! from mbed 01</p>" "\r\n"                                 \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

#define PORT 8080

#define IP         "192.168.0.101"
#define GATEWAY    "192.168.0.1"
#define MASK       "255.255.255.0"

EthernetInterface eth;
TCPServer srv;
TCPSocket clt_sock;
SocketAddress clt_addr;

const char *ip = 0;
const char *mac = 0;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

void split(char **arr, char *str, const char *del) {
    char *s = strtok(str, del);
    while(s != NULL) {
        *arr++ = s;
        s = strtok(NULL, del);
    }
}

/* Define function */
void ServerInit() {
    eth.disconnect();
    eth.set_network(IP,MASK,GATEWAY);
    eth.connect();
    
    ip = eth.get_ip_address();
    mac = eth.get_mac_address();
    printf("mbed's IP address is: %s\n\r", ip ? ip : "No IP");
    printf("mbed's MAC address is: %s\n\r", mac ? mac : "No MAC");
}

bool OpenServer() {
    /* Open the server on ethernet stack */
    int ii=srv.open(&eth);

    if (ii<0) {
        printf("open error: %i \r\n",ii);
        return true;
    }
    printf("server open\r\n");
    return false;
}

bool BindPort() {
    /* Bind the HTTP port (TCP 80) to the server */
    int ii=srv.bind(ip, 80);
    if (ii<0) {
        printf("bind error: %i \r\n",ii);
        return true;
    }
    printf("Bound\r\n");
    return false;
}

bool ListenConnections() {
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    if (srv.listen()<0) {
        printf("listen error\r\n");
        return true;
    }
    printf("Listening\r\n");
    return false;
}

bool CheckAccept() {
    int ii = srv.accept(&clt_sock);
    if (ii<0) {
        printf("accept error: %i \r\n",ii);
        return true;
    }
    printf("Socket Accepted\r\n");
    return false;
}

bool EventLoop() {
    while (true) {
        srv.accept(&clt_sock, &clt_addr);
        
        //printf("The target IP address is '%s'\n", eth.get_ip_address());
        //printf("The target MAC address is '%s'\n", eth.get_mac_address());
        printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        
        // Receive data
        char buf[100];
        clt_sock.recv(buf, 100);
        printf("recv: %s\n", buf);
        
        char *arr[10];
        split(arr, buf, " ");

        /*for(int jj=0;jj<10;jj++) {
            printf("## %03d: %s\n", jj, arr[jj]);
        }*/
        
        if (strcmp(arr[0], "GET")==0) {
            printf("## ##: GET\n");
            char response[] = HTTP_STATUS_LINE;
            strcat(response, "\r\n");
            strcat(response, HTTP_HEADER_FIELDS);
            strcat(response, "\r\n");
            strcat(response, "\r\n");
            strcat(response, "001 GET\r\n");
            clt_sock.send(response, strlen(response));
        }
        
        if (strcmp(arr[0], "POST")==0) {
            printf("## ##: POST\n");
            char response[] = HTTP_STATUS_LINE;
            strcat(response, "\r\n");
            strcat(response, HTTP_HEADER_FIELDS);
            strcat(response, "\r\n");
            strcat(response, "\r\n");
            strcat(response, "002 POST\r\n");
            clt_sock.send(response, strlen(response));
        }

        // Send data
        //clt_sock.send(HTTP_RESPONSE, strlen(HTTP_RESPONSE));
        
        // Close the socket
        clt_sock.close();
        
    }
    return false;
}

/* Main function */
int main(){
    printf("mbed HTTP server for REST API\n");
    
    ServerInit();
    led1 = 1;
    led2 = 0;
    led3 = 0;
    wait(0.1);
    
    if (OpenServer()) return 0;
    
    if (BindPort()) return 0;
    
    if (ListenConnections()) return 0;
    
    //if (CheckAccept()) return 0;
    
    led1 = 0;
    led2 = 1;
    led3 = 0;
    wait(0.1);
    
    if (EventLoop()) return 0;
    
}