
#if !FEATURE_LWIP
#error[NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "module_for_all.h"

#define PORT 8080

#define IP1 "192.168.20.101"
#define IP2 "192.168.20.102"
#define IP3 "192.168.20.103"
#define IP4 "192.168.20.104"
#define GATEWAY "192.168.20.1"
#define MASK "255.255.255.0"

const char *ip = 0;
const char *mac = 0;

DataStorage ds_manager("");
IR_Manager ir_manager("");
WheelManager wheel_manager("");

NetworkManager *net_manager = new NetworkManager(IP1, GATEWAY, MASK, PORT);
RestAPI_Manager *restAPI_manager = new RestAPI_Manager(&ds_manager, &ir_manager, &wheel_manager, IP1, "1");

//NetworkManager  net_manager();
//RestAPI_Manager restAPI_manager();

void checkServer()
{
    //TCPSocket socket;

    printf("checkServer Start...\r\n");

    ir_manager.digitalTest();
    ir_manager.analogTest();

    // Open a socket on the network interface, and create a TCP connection to www.arm.com
    net_manager->clt_sock.open(&(net_manager->eth));
    net_manager->clt_sock.connect("192.168.20.1", 81);

    // Send a simple http request
    //char sbuffer[] = "GET /iamok/ HTTP/1.1\r\nHost: 192.168.20.1\r\n\r\n";
    std::string sbuffer_str = "GET /iamok/ HTTP/1.1\r\nHost: 192.168.20.1\r\n\r\n";
    char *sbuffer = new char[sbuffer_str.length() + 1];

    //tmpString = stringToChar(tmpResponse);
    stringToChar(sbuffer, sbuffer_str);

    //clt_sock.send(tmpString, strlen(tmpString));

    int scount = net_manager->clt_sock.send(sbuffer, strlen(sbuffer));
    printf("sent %d [%.*s]\r\n", scount, strstr(sbuffer, "\r\n") - sbuffer, sbuffer);

    if (scount >= 0)
    {
        // Recieve a simple http response and print out the response line
        char *rbuffer = new char[1024];
        //char* buf = new char[1024];
        //int rcount = net_manager->clt_sock.recv(rbuffer, sizeof rbuffer);
        int rcount = net_manager->clt_sock.recv(rbuffer, 100);
        printf("recv %d [%.*s]\r\n", rcount, strstr(rbuffer, "\r\n") - rbuffer, rbuffer);
        delete[] rbuffer;
        DataStorage::isNoConnectServer = false;
    }
    else
    {
        DataStorage::set_PWM_status(1, 0, 0);
        DataStorage::set_PWM_status(2, 0, 0);
        DataStorage::set_PWM_status(3, 0, 0);
        DataStorage::set_PWM_status(4, 0, 0);

        for (int ii = 0; ii < 5; ii++)
        {
            DataStorage::WM_PWM[ii][0] = 1;
            DataStorage::WM_PWM[ii][1] = 0;
        }

        /*(DataStorage::_WM_PWM_out01).period(DataStorage::WM_PWM[0][0]);
        (DataStorage::_WM_PWM_out02).period(DataStorage::WM_PWM[1][0]);
        (DataStorage::_WM_PWM_out03).period(DataStorage::WM_PWM[2][0]);
        (DataStorage::_WM_PWM_out04).period(DataStorage::WM_PWM[3][0]);
        
        (DataStorage::_WM_PWM_out01).write(DataStorage::WM_PWM[0][1]);
        (DataStorage::_WM_PWM_out02).write(DataStorage::WM_PWM[1][1]);
        (DataStorage::_WM_PWM_out03).write(DataStorage::WM_PWM[2][1]);
        (DataStorage::_WM_PWM_out04).write(DataStorage::WM_PWM[3][1]);*/
        for (int ii = 0; ii < 4; ii++)
            ds_manager.set_PWM_period(ii, 1);
        for (int ii = 0; ii < 4; ii++)
            ds_manager.set_PWM_write(ii, 0);
        DataStorage::isNoConnectServer = true;
    }

    // Close the socket to return its memory and bring down the network interface
    net_manager->clt_sock.close();

    delete[] sbuffer;
    printf("checkServer Over...\r\n");
}

void checkServerLoop()
{
    while (true)
    {
        checkServer();
    }
}

void checkServerThread()
{
    Thread thread_connect;
    thread_connect.start(checkServerLoop);
}

bool EventLoop()
{
    while (true)
    {
        printf("$$ EventLoop New\r\n");

        //Thread threadMain01;
        //restAPI_manager.changeThread(&threadMain01);

        //printf("$$ EventLoop Change Thread\r\n");

        LED_NetWait();

        printf("$$ EventLoop Waiting\r\n");

        net_manager->AcceptEvent();
        //printf("$$ EventLoop run Response\r\n");
        if (DataStorage::isAccept)
        {
            LED_NetProcess();
            DataStorage::http_method = net_manager->getHttpMethod();
            DataStorage::api_command = net_manager->getApiCommand();
            DataStorage::response = restAPI_manager->runCommand(DataStorage::http_method, DataStorage::api_command);
            net_manager->SendResponseEvent(DataStorage::response);
            DataStorage::noAcceptCount = 0;
        }
        else
        {
            DataStorage::noAcceptCount += 1;
            if (DataStorage::noAcceptCount == 20)
            {
                DataStorage::noAcceptCount = 0;
                if (!DataStorage::isTestMode)
                {
                    LED_NetProcess_checkServer();
                    checkServer();
                }
            }
        }

        //DataStorage::http_method = net_manager->getHttpMethod();
        //DataStorage::api_command = net_manager->getApiCommand();

        //DataStorage::response = restAPI_manager->runCommand(DataStorage::http_method, DataStorage::api_command);
        //net_manager->SendResponseEvent(DataStorage::response);

        DataStorage::isAccept = false;
        printf("$$ EventLoop Finish\r\n");
    }

    //printf("$$ EventLoop ALL Finish\r\n");
    return false;
}

void checkIP_Mode()
{
    DigitalIn IP_Select1(PD_7);
    DigitalIn IP_Select2(PD_6);

    DigitalIn Test_Mode(PC_14);

    DataStorage::ipSelect = 1;

    if (IP_Select1.read() == 1)
    {
        DataStorage::ipSelect += 1;
    }

    if (IP_Select2.read() == 1)
    {
        DataStorage::ipSelect += 2;
    }

    switch (DataStorage::ipSelect)
    {
    case 1:
        DataStorage::ipChar = IP1;
        break;
    case 2:
        DataStorage::ipChar = IP2;
        break;
    case 3:
        DataStorage::ipChar = IP3;
        break;
    case 4:
        DataStorage::ipChar = IP4;
        break;
    }

    DataStorage::ipStr = intToString(DataStorage::ipSelect);

    net_manager->SetConfig(DataStorage::ipChar, GATEWAY, MASK, PORT);
    restAPI_manager->SetConfig(DataStorage::ipChar, DataStorage::ipStr);

    printf("mbed %d Start\r\n", DataStorage::ipSelect);

    if (Test_Mode.read() == 1)
    {
        DataStorage::isTestMode = true;
        printf("mbed %d mode Test\r\n", DataStorage::ipSelect);
    }
    else
    {
        DataStorage::isTestMode = false;
        printf("mbed %d mode Normal\r\n", DataStorage::ipSelect);
    }
}

int netInit()
{
    net_manager->ServerInit();
    printf("ServerInit\r\n");

    if (net_manager->OpenServer())
        return -1;
    printf("OpenServer\r\n");

    if (net_manager->BindPort())
        return -1;
    printf("BindPort\r\n");

    if (net_manager->ListenConnections())
        return -1;
    printf("ListenConnections\r\n");

    return 0;
}

void start()
{
    printf("mbed Power Start\r\n");
    LED_PowerStart();

    checkIP_Mode();
    wait(0.5);
    netInit();
}
/* Main function */
int main()
{
    start();

    if (EventLoop())
    {
        return 0;
    }
}