#include "module_for_all.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Serial PC(SERIAL_TX, SERIAL_RX);

void split(const std::string& tmpString,
            std::vector<std::string>& stringVector,
            const char* delim = " ") {
    stringVector.clear();
    char* buffer = new char[tmpString.size() + 1];
    std::copy(tmpString.begin(), tmpString.end(), buffer);
    char* p = std::strtok(buffer, delim);
    do {
        stringVector.push_back(p);
    } while ((p = std::strtok(NULL, delim)));
    
    delete [] buffer;
}

/*char* stringToChar(std::string tmpString) {
    char* tmpChar = new char [tmpString.length()+1];
    std::strcpy(tmpChar, tmpString.c_str());
    return tmpChar;
}*/

void stringToChar(char* tmpChar, std::string tmpString) {
    //char* tmpChar = new char [tmpString.length()+1];
    std::strcpy(tmpChar, tmpString.c_str());
    //return tmpChar;
}

int stringToInt(std::string tmpString) {
    int tmpInt;
    istringstream is(tmpString);
    is>>tmpInt;
    return tmpInt;
}

std::string intToString(int tmpInt) {
    ostringstream stream;
    stream << tmpInt;
    std::string tmpInt_s = stream.str();
    return tmpInt_s;
}

std::string floatToString(float tmpFloat) {
    ostringstream stream;
    stream << tmpFloat;
    std::string tmpFloat_s = stream.str();
    return tmpFloat_s;
}

void LED_PowerStart() {
    led1 = 1;
    led2 = 0;
    led3 = 0;
    //wait(0.1);
}

void LED_NetWait() {
    led1 = 0;
    led2 = 1;
    led3 = 0;
    //wait(0.1);
}

void LED_NetProcess() {
    led1 = 0;
    led2 = 0;
    led3 = 1;
    //wait(0.1);
}

void LED_NetProcess_checkServer() {
    led1 = 1;
    led2 = 0;
    led3 = 1;

    if (DataStorage::isNoConnectServer) {
        led1 = 0;
        wait(0.1);

        led1 = 1;
        wait(0.1);

        led1 = 0;
        wait(0.1);

        led1 = 1;
    }
}

void myPrint(const char* format, ...){
    char* tmpS;
    //sprintf(tmpS, format);
    //PC.printf(tmpS);
    
    va_list arg;
    int done;
    va_start (arg, format);
    done = vsprintf (tmpS, format, arg);
    va_end (arg);
    
    PC.printf(tmpS);
    delete tmpS;
    //printf(tmpS);
    //wait(0.1);
}

int countRoot(std::string& tmpString) {
    int count = 0;
    //char* tmpAPI = stringToChar(tmpString);
    char* tmpAPI = new char [tmpString.length()+1];
    std::strcpy(tmpAPI, tmpString.c_str());
    
    for (int ii=0;ii<strlen(tmpAPI);ii++) {
        if(tmpAPI[ii]=='/') {
            count++;
        }
    }
    
    delete [] tmpAPI;
    return count;
}