#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "module_for_all.h"

#define PORT 8080

#define IP1        "192.168.20.101"
#define IP2        "192.168.20.102"
#define GATEWAY    "192.168.20.1"
#define MASK       "255.255.255.0"

const char* ip = 0;
const char* mac = 0;

DigitalIn  IP_Select2(PG_2);

NetworkManager  net_manager(IP1, GATEWAY, MASK, PORT);
RestAPI_Manager restAPI_manager(IP1, "1");

//NetworkManager  net_manager();
//RestAPI_Manager restAPI_manager();

Timer t;
CPU_Usage cpu(t, 1);

bool EventLoop() {
    uint8_t value = 0;
    while (true) {
        printf("$$ EventLoop New\r\n");
        LED_NetWait();
        
        net_manager.AcceptEvent();
        //printf("$$ EventLoop run Response\r\n");
        LED_NetProcess();
        
        std::string http_method = net_manager.getHttpMethod();
        std::string api_command = net_manager.getApiCommand();
        
        std::string response = restAPI_manager.runCommand(http_method, api_command);
        
        value = cpu.update();
        //printf("CPU %i", value);
        
        net_manager.SendResponseEvent(response);
        printf("$$ EventLoop Finish\r\n");
    }
    
    printf("$$ EventLoop ALL Finish\r\n");
    return false;
}

/* Main function */
int main(){
    
    printf("mbed Power Start\r\n");
    LED_PowerStart();
    cpu.working();
    
    if (IP_Select2.read() == 1){
        net_manager.SetConfig(IP2, GATEWAY, MASK, PORT);
        restAPI_manager.SetConfig(IP2, "2");
        printf("mbed 02 Start\r\n");

    } else {
        net_manager.SetConfig(IP1, GATEWAY, MASK, PORT);
        restAPI_manager.SetConfig(IP1, "1");
        printf("mbed 01 Start\r\n");
    }
    
    net_manager.ServerInit();
    printf("ServerInit\r\n");
    
    if (net_manager.OpenServer()) return 0;
    printf("OpenServer\r\n");
    
    if (net_manager.BindPort()) return 0;
    printf("BindPort\r\n");
    
    if (net_manager.ListenConnections()) return 0;
    printf("ListenConnections\r\n");
    
    if (EventLoop()) {
        cpu.stopped();
        return 0;
    }
}