#include "module_for_all.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

void split(const std::string& tmpString,
            std::vector<std::string>& stringVector,
            const char* delim = " ") {
    stringVector.clear();
    char* buffer = new char[tmpString.size() + 1];
    std::copy(tmpString.begin(), tmpString.end(), buffer);
    char* p = std::strtok(buffer, delim);
    do {
        stringVector.push_back(p);
    } while ((p = std::strtok(NULL, delim)));
}

char* stringToChar(std::string tmpString) {
    char* tmpChar = new char [tmpString.length()+1];
    std::strcpy(tmpChar, tmpString.c_str());
    return tmpChar;
}

void LED_PowerStart() {
    led1 = 1;
    led2 = 0;
    led3 = 0;
    wait(0.1);
}

void LED_NetWait() {
    led1 = 0;
    led2 = 1;
    led3 = 0;
    wait(0.1);
}

void LED_NetProcess() {
    led1 = 0;
    led2 = 0;
    led3 = 1;
    wait(0.1);
}

int countRoot(std::string& tmpString) {
    int count = 0;
    char* tmpAPI = stringToChar(tmpString);
    for (int ii=0;ii<strlen(tmpAPI);ii++) {
        if(tmpAPI[ii]=='/') {
            count++;
        }
    }
    return count;
}