#include "module_for_all.h"

#include "WheelManager.h"

WheelManager runWheel("");
//Serial PC(SERIAL_TX, SERIAL_RX);

RestAPI_Manager::RestAPI_Manager(DataStorage* tmpDS) {
    _ip = "192.168.20.101";
    _ip_s = std::string(_ip);
    _main = 1;
    
    ds_m = tmpDS;
    //threadRM = tmpThread;
}

RestAPI_Manager::RestAPI_Manager(DataStorage* tmpDS, char* IP, std::string Main) {
    _ip = IP;
    _ip_s = std::string(_ip);
    _main = Main;
    
    ds_m = tmpDS;
    //threadRM = tmpThread;
}

void RestAPI_Manager::SetConfig(char* IP, std::string Main) {
    _ip = IP;
    _ip_s = std::string(_ip);
    _main = Main;
    printf("RestAPI_Manager::SetConfig OK\r\n");
}

/*void RestAPI_Manager::changeThread(Thread* tmpThread) {
    threadRM = tmpThread;
}*/

std::string RestAPI_Manager::runCommand(std::string HTTP_METHOD, std::string API_COMMAND) {
    std::string _response = "";
    
    if (HTTP_METHOD.compare("GET") == 0) {
        _response.append(switchCommand_GET(API_COMMAND));
        //_response.append("001 GET");
        
    } else if (HTTP_METHOD.compare("POST") == 0) {
        _response.append(switchCommand_POST(API_COMMAND));
        //_response.append("002 POST");
        
    } else {
        /*response.append("\r\n");
        response.append(HTTP_HEADER_FIELDS);
        response.append("\r\n\r\n");
        response.append("000 No Method\r\n");*/
        //makeResponse("000 No Method");
        _response.append("000 No Method");
    }
    
    return _response;
}

std::string RestAPI_Manager::switchCommand_GET(std::string API_COMMAND) {
    int count = countRoot(API_COMMAND);
    
    std::vector<std::string> _commandList;
    _commandList.reserve(10);
    split(API_COMMAND, _commandList, "/");
    
    std::string returnString = "";
    
    //returnString.append(_commandList[0]);
    //returnString.append("\r\n");
    
    if (_commandList[0].compare("who") == 0) {
        /*printf("mbed #");
        printf(_main);
        printf("mbed #\r\n");*/
        returnString.append("mbed #");
        //char* tmpS;
        //sprintf(tmpS,"%d",_main);
        //std::string tmpS2(tmpS);
        returnString.append(_main);
        returnString.append("\r\n");
        returnString.append(_ip_s);
    } else if (_commandList[0].compare("ir_test") == 0) {

        AnalogIn  IR_Test(PA_3);
        float tmp_v = IR_Test.read()*1000.0f;
        printf("Voltage: %f\r\n", tmp_v);
        
        /*std::ostringstream ss;
        ss << tmp_v;
        std::string ss2(ss.str());*/
        
        /*printf("mbed #");
        printf(_main);
        printf("mbed #\r\n");*/
        
        char* tmpS;
        sprintf(tmpS,"%5.5f%\r\n",tmp_v);
        std::string tmpS2(tmpS);
        returnString.append(tmpS);
    } else if (_commandList[0].compare("temp_test") == 0) {
        
        AnalogIn adc_temp(ADC_TEMP);
        AnalogIn adc_vref(ADC_VREF);
        float tmp_adc_temp = adc_temp.read()*100.0f;
        float tmp_adc_vref = adc_vref.read()*1.0f;
        printf("Temp: %f\r\n", tmp_adc_temp);
        printf("Voltage: %f\r\n", tmp_adc_vref);
        
        
        char* tmpS;
        printf("### test 01\r\n");
        
        sprintf(tmpS,"Temp: %5.5f, Voltage: %5.5f \r\n",tmp_adc_temp, tmp_adc_vref);
        printf("### test 02\r\n");
        
        std::string tmpS2(tmpS);
        printf("### test 03\r\n");
        
        //returnString.append(tmpS);
        printf("### test 04\r\n");
        
        delete tmpS;
        
    } else if (_commandList[0].compare("run_test") == 0) {
        int tmpPeriod = stringToInt(_commandList[1]);
        int tmpCycle = stringToInt(_commandList[2]);
        int tmpDirection = stringToInt(_commandList[3]);
        int tmpHowLong = stringToInt(_commandList[4]);

        //int tmp[5][2] = {{tmpDirection, tmpHowLong}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}};
        int** tmp;
        tmp = new int *[5];
        int i;
        
        for(i=0;i<5;i++){
            tmp[i]=new int[2];
            if (i!=0){
                tmp[i][0] = tmpPeriod;
                tmp[i][1] = tmpCycle;
            }
        }
    
        //tmp = {{tmpDirection, tmpHowLong}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}};
        tmp[0][0] = tmpDirection;
        tmp[0][1] = tmpHowLong;

        //runWheel.runControl(ds_m, threadRM, tmp);
        runWheel.runControl(ds_m, tmp);
        //myPrint("### 03\r\n");
        
        //char* tmpS="";
        //myPrint("### 04-1\r\n");
        //sprintf(tmpS,"RUN");
        
        //myPrint(tmpS);
        //myPrint("### 04-2\r\n");
        //returnString.append(tmpS);
        //std::string tmpStr = "RUN";
        returnString.append("RUN");
        //myPrint("### 05\r\n");
        
        for(i=0; i<5; i++){
            delete [] tmp[i];
        }
        delete [] tmp;
        //return tmpStr;
        
    } else if (_commandList[0].compare("run_test_move") == 0) {
        //int tmpTop = stringToInt(_commandList[1]);
        //int tmpLeft = stringToInt(_commandList[2]);
        std::string tmpTop = _commandList[1];
        std::string tmpLeft = _commandList[2];
        
        printf("### tmpTop: %s ; tmpLeft: %s ;\r\n", tmpTop, tmpLeft);

        returnString.append("tmpTop: ");
        returnString.append(tmpTop);
        returnString.append("; ");
        returnString.append("tmpLeft: ");
        returnString.append(tmpLeft);
        returnString.append(";\r\n");
        
    } else if (_commandList[0].compare("run_move1") == 0) {
        int tmpPeriod = stringToInt(_commandList[1]);
        //int tmpCycle = stringToInt(_commandList[2]);
        //int tmpHowLong = stringToInt(_commandList[4]);
        
        int tmpDirection = stringToInt(_commandList[2]);
        int tmpSpeed = stringToInt(_commandList[3]);
        //int tmpPeriod = 1;
        int tmpHowLong = 1;

        //int tmp[5][2] = {{tmpDirection, tmpHowLong}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}};
        int** tmp;
        tmp = new int *[5];
        int i;
        
        for(i=0;i<5;i++){
            tmp[i]=new int[2];
            if (i!=0){
                tmp[i][0] = tmpPeriod;
                tmp[i][1] = tmpSpeed;
            }
        }
    
        //tmp = {{tmpDirection, tmpHowLong}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}};
        tmp[0][0] = tmpDirection;
        tmp[0][1] = tmpHowLong;

        //runWheel.runControl(ds_m, threadRM, tmp);
        runWheel.runControl(ds_m, tmp);
        //myPrint("### 03\r\n");
        
        //char* tmpS="";
        //myPrint("### 04-1\r\n");
        //sprintf(tmpS,"RUN");
        
        //myPrint(tmpS);
        //myPrint("### 04-2\r\n");
        //returnString.append(tmpS);
        //std::string tmpStr = "RUN";
        returnString.append("RUN");
        //myPrint("### 05\r\n");
        
        for(i=0; i<5; i++){
            delete [] tmp[i];
        }
        delete [] tmp;
        //return tmpStr;
        
    } else if (_commandList[0].compare("run_move2") == 0) {
        int tmpSpeed1 = stringToInt(_commandList[1]);
        int tmpIsRight1 = stringToInt(_commandList[2]);
        
        int tmpSpeed2 = stringToInt(_commandList[3]);
        int tmpIsRight2 = stringToInt(_commandList[4]);
        
        int tmpSpeed3 = stringToInt(_commandList[5]);
        int tmpIsRight3 = stringToInt(_commandList[6]);
        
        int tmpSpeed4 = stringToInt(_commandList[7]);
        int tmpIsRight4 = stringToInt(_commandList[8]);
        
        int tmpPeriod = stringToInt(_commandList[9]);
        int tmpDirection = stringToInt(_commandList[10]);
        
        //int tmpCycle = stringToInt(_commandList[2]);
        //int tmpHowLong = stringToInt(_commandList[4]);
        
        //int tmpDirection = stringToInt(_commandList[2]);
        //int tmpSpeed = stringToInt(_commandList[3]);
        //int tmpPeriod = 1;
        int tmpHowLong = 1;

        //int tmp[5][2] = {{tmpDirection, tmpHowLong}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}};
        int** tmp;
        tmp = new int *[5];
        int i;
        
        for(i=0;i<5;i++){
            tmp[i]=new int[2];
            if (i==1){
                tmp[i][0] = tmpPeriod;
                tmp[i][1] = tmpSpeed1;
            } else if (i==2) {
                tmp[i][0] = tmpPeriod;
                tmp[i][1] = tmpSpeed2;
            } else if (i==3) {
                tmp[i][0] = tmpPeriod;
                tmp[i][1] = tmpSpeed3;
            } else if (i==4) {
                tmp[i][0] = tmpPeriod;
                tmp[i][1] = tmpSpeed4;
            }
        }
    
        //tmp = {{tmpDirection, tmpHowLong}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}, {tmpPeriod, tmpCycle}};
        tmp[0][0] = tmpDirection;
        tmp[0][1] = tmpHowLong;

        //runWheel.runControl(ds_m, threadRM, tmp);
        runWheel.runControl(ds_m, tmp);
        //myPrint("### 03\r\n");
        
        //char* tmpS="";
        //myPrint("### 04-1\r\n");
        //sprintf(tmpS,"RUN");
        
        //myPrint(tmpS);
        //myPrint("### 04-2\r\n");
        //returnString.append(tmpS);
        //std::string tmpStr = "RUN";
        returnString.append("RUN");
        //myPrint("### 05\r\n");
        
        for(i=0; i<5; i++){
            delete [] tmp[i];
        }
        delete [] tmp;
        //return tmpStr;
        
    } else {
        returnString.append("No Command");
    }
    /*std::string tmp = "";
    
    //char buf[20];
    char* buf;
    sprintf(buf,"%03d", count);
    string tmpCount(buf);
    tmp.append("count:");
    tmp.append(tmpCount);
    tmp.append("\r\n");
    
    for(int ii=0;ii<count-1;ii++) {
        sprintf(buf,"%03d", ii);
        string tmpII(buf);

        tmp.append(tmpII);
        tmp.append(":");
        tmp.append(_commandList[ii]);
        tmp.append(",");
    }
    tmp.append("\r\n");
    tmp.append(API_COMMAND);
    
    printf("### %%% \r\n");
    printf(stringToChar(API_COMMAND));
    printf("\r\n");
    printf(stringToChar(tmp));
    printf("### %%% \r\n");
    return tmp;*/
    
    _commandList.clear();
    std::vector<std::string>(_commandList).swap(_commandList);
    
    return returnString;
}

std::string RestAPI_Manager::switchCommand_POST(std::string API_COMMAND) {
    /*int count = countRoot(API_COMMAND);
    
    std::vector<std::string> _commandList;
    _commandList.reserve(10);
    split(API_COMMAND, _commandList, "/");
    std::string tmp = "";
    
    char buf[20];
    sprintf(buf,"%03d", count);
    string tmpCount(buf);
    tmp.append("count:");
    tmp.append(tmpCount);
    tmp.append("\r\n");
    
    for(int ii=0;ii<count-1;ii++) {
        sprintf(buf,"%03d", ii);
        string tmpII(buf);

        tmp.append(tmpII);
        tmp.append(":");
        tmp.append(_commandList[ii]);
        tmp.append(",");
    }
    tmp.append("\r\n");
    tmp.append(API_COMMAND);
    
    printf("### %%% \r\n");
    printf(stringToChar(API_COMMAND));
    printf("\r\n");
    printf(stringToChar(tmp));
    printf("### %%% \r\n");
    return tmp;*/
    int count = countRoot(API_COMMAND);
    
    std::vector<std::string> _commandList;
    _commandList.reserve(10);
    split(API_COMMAND, _commandList, "/");
    
    std::string returnString = "";
    
    //returnString.append(_commandList[0]);
    //returnString.append("\r\n");
    
    if (_commandList[0].compare("who2") == 0) {
        /*printf("mbed #");
        printf(_main);
        printf("mbed #\r\n");*/
        returnString.append("mbed #");
        //char* tmpS;
        //sprintf(tmpS,"%d",_main);
        //std::string tmpS2(tmpS);
        returnString.append(_main);
        returnString.append("\r\n");
        returnString.append(_ip_s);
    } else {
        returnString.append("No Command");
    }
    
    return returnString;
}