#ifndef NETWORKMANAGER_H
#define NETWORKMANAGER_H

#include "module_for_all.h"

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY ""                                     \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Hello ! mbed</h1>" "\r\n"                              \
"      <p>It works ! from mbed</p>" "\r\n"                                 \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

//void CheckConnectServer();

class NetworkManager {
public:
    NetworkManager();
    NetworkManager(char*, char*, char*, int);
    
    /* Define function */
    void SetConfig(char*, char*, char*, int);
    bool ServerInit();
    
    bool OpenServer();
    
    bool BindPort();
    
    bool ListenConnections();
    
    bool CheckAccept();
    
    void AcceptEvent();
    void SendResponseEvent(std::string);
    
    /* Define self function */
    std::string getHttpMethod();
    std::string getApiCommand();
    std::string makeResponse(std::string);
    
    //void CheckConnectServer();
    //void threadCheckConnectServer();
    
    EthernetInterface   eth;
    TCPServer       srv;
    TCPSocket       clt_sock;
    SocketAddress   clt_addr;
    
private:
    char*   _ip;
    char*   _gateway;
    char*   _mask;
    char*   _mac;
    int     _port;
    
    const char* _m_ip;
    const char* _m_mac;
    
    std::vector<std::string> _recvList;
    
    //char  *_http_method;
    //char  *_api_command;
    
    std::string _http_method;
    std::string _api_command;
    
};

#endif