#include "module_for_all.h"

NetworkManager::NetworkManager() {
    _ip = "192.168.20.101";
    _gateway = "192.168.20.1";
    _mask = "255.255.255.0";
    _port = 8080;
    
    _m_ip = "";
    _m_mac = "";
    
    eth.set_network(_ip,_mask,_gateway);
    
    std::string _http_method = "";
    std::string _api_command = "";
}

NetworkManager::NetworkManager(char* IP, char* GATEWAY, char* MASK, int PORT) {
    _ip = IP;
    _gateway = GATEWAY;
    _mask = MASK;
    _port = PORT;
    
    _m_ip = "";
    _m_mac = "";
    
    eth.set_network(_ip,_mask,_gateway);

    std::string _http_method = "";
    std::string _api_command = "";
}

void NetworkManager::SetConfig(char* IP, char* GATEWAY, char* MASK, int PORT) {
    _ip = IP;
    _gateway = GATEWAY;
    _mask = MASK;
    _port = PORT;
    
    eth.set_network(_ip,_mask,_gateway);
    
    printf("NM::SetConfig OK\r\n");
}

bool NetworkManager::ServerInit() {
    //eth.disconnect();
    //eth.init();
    //eth.set_network(_ip,_mask,_gateway);
    int ii = eth.connect();
    
    printf("NM connecting ...... \r\n");
    
    if (ii>=0){
        _m_ip = eth.get_ip_address();
        _m_mac = eth.get_mac_address();
        
        if(_m_ip != ""){
            printf("mbed's IP address is: %s\r\n", _m_ip);
        } else {
            printf("mbed's IP address is: No IP\r\n");
        }
        
        if(_m_mac != ""){
            printf("mbed's MAC address is: %s\r\n", _m_mac);
        } else {
            printf("mbed's MAC address is: No MAC\r\n");
        }
        
        printf("NM connected \r\n");
        return false;
    }
    
    printf("NM connect failed ...... \r\n");
    return true;
}

/*void NetworkManager::ServerInit() {
    eth.disconnect();
    eth.set_network(_ip,_mask,_gateway);
    eth.connect();
    
    _m_ip = eth.get_ip_address();
    _m_mac = eth.get_mac_address();
    printf("mbed's IP address is: %s\n\r", _m_ip ? _m_ip : "No IP");
    printf("mbed's MAC address is: %s\n\r", _m_mac ? _m_mac : "No MAC");
}*/

bool NetworkManager::OpenServer() {
    /* Open the server on ethernet stack */
    int ii=srv.open(&eth);

    if (ii<0) {
        printf("open error: %i \r\n",ii);
        return true;
    }
    printf("server open\r\n");
    return false;
}

bool NetworkManager::BindPort() {
    /* Bind the HTTP port (TCP 80) to the server */
    int ii=srv.bind(_m_ip, 80);
    if (ii<0) {
        printf("bind error: %i \r\n",ii);
        return true;
    }
    printf("Bound\r\n");
    //LXM Add
    srv.set_blocking(false);
    return false;
}

bool NetworkManager::ListenConnections() {
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    if (srv.listen()<0) {
        printf("listen error\r\n");
        return true;
    }
    printf("Listening\r\n");
    return false;
}

bool NetworkManager::CheckAccept() {
    int ii = srv.accept(&clt_sock);
    if (ii<0) {
        printf("accept error: %i \r\n",ii);
        return true;
    }
    printf("Socket Accepted\r\n");
    return false;
}

/*void NetworkManager::AcceptEvent() {
    srv.accept(&clt_sock, &clt_addr);
        
    //printf("The target IP address is '%s'\n", eth.get_ip_address());
    //printf("The target MAC address is '%s'\n", eth.get_mac_address());
    printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        
    // Receive data
    //char buf[1024];
    char* buf = new char[1024];
    clt_sock.recv(buf, 100);
    printf("## print recv: %s\r\n", buf);
    printf("## print recv: Finish\r\n");
    //char *arr[10];
    //memset(arr, 0, sizeof(arr));
    
    //std::string tmpBuf(buf);
    std::string* tmpBuf = new std::string(buf);

    _recvList.reserve(100);
    split(*tmpBuf, _recvList, " ");

    _http_method = _recvList[0];
    _api_command = _recvList[1];
    
    delete [] buf;
    
    delete tmpBuf;
}*/

void NetworkManager::AcceptEvent() {
    DataStorage::isAccept = true;
    if(srv.accept(&clt_sock, &clt_addr)<0){
        DataStorage::isAccept = false;
        return;
    }
        
    //printf("The target IP address is '%s'\n", eth.get_ip_address());
    //printf("The target MAC address is '%s'\n", eth.get_mac_address());
    printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        
    // Receive data
    //char buf[1024];
    char* buf = new char[1024];
    clt_sock.recv(buf, 100);
    //printf("## print recv: %s\r\n", buf);
    printf("## print recv: Finish\r\n");
    //char *arr[10];
    //memset(arr, 0, sizeof(arr));
    
    //std::string tmpBuf(buf);
    std::string* tmpBuf = new std::string(buf);

    _recvList.reserve(100);
    split(*tmpBuf, _recvList, " ");

    _http_method = _recvList[0];
    _api_command = _recvList[1];
    
    delete [] buf;
    
    delete tmpBuf;
}

void NetworkManager::SendResponseEvent(std::string _response) {
    
    //std::string response = HTTP_STATUS_LINE;
    
    /*printf("$$ _recvList[0] : %s \r\n", _recvList[0].c_str());
    printf("$$ _recvList[1] : %s \r\n", _recvList[1].c_str());
    printf("$$ _recvList[2] : %s \r\n", _recvList[2].c_str());
    printf("$$ _recvList[3] : %s \r\n", _recvList[3].c_str());*/
    

    //std::string tmpResponse = "";
    //tmpResponse = makeResponse(_response);
    std::string tmpResponse = makeResponse(_response);
    //char* tmpString = new char;
    char* tmpString = new char [tmpResponse.length()+1];
    
    //tmpString = stringToChar(tmpResponse);
    stringToChar(tmpString, tmpResponse);
    clt_sock.send(tmpString, strlen(tmpString));
    //clt_sock.send(response, strlen(response));
    
    // Send data
    //clt_sock.send(HTTP_RESPONSE, strlen(HTTP_RESPONSE));
    
    // Close the socket
    clt_sock.close();
    
    delete [] tmpString;
    
    printf("Socket close\r\n");
}

std::string NetworkManager::getHttpMethod() {
    return _http_method;
}


std::string NetworkManager::getApiCommand() {
    return _api_command;
}

std::string NetworkManager::makeResponse(std::string tmpResponse) {
    std::string returnResponse = HTTP_STATUS_LINE;
    returnResponse.append("\r\n");
    returnResponse.append(HTTP_HEADER_FIELDS);
    returnResponse.append("\r\n\r\n");
    returnResponse.append(tmpResponse);
    returnResponse.append("\r\n");
    
    return returnResponse;
}

/*void CheckConnectServer() {

    printf("###01\n");
    
    //EthernetInterface eth;
    printf("###02\n");
    
    //eth.init(); //Use DHCP
    //eth.connect();
    printf("###03 IP Address is %s\n", eth.get_ip_address());
    
    //TCPSocketConnection sock;
    //TCPSocket sock;
    printf("###04\n");
    
    clt_sock.open(&eth);
    printf("###05-1\n");
    
    clt_sock.connect("192.168.20.1", 5001);
    printf("###05-2\n");
    
    char http_cmd[] = "GET /iamok/ HTTP/1.1\r\n\r\n";
    printf("###06\n");
    
    //sock.send_all(http_cmd, sizeof(http_cmd)-1);
    clt_sock.send(http_cmd, sizeof(http_cmd));
    printf("###07\n");
    
    char buffer[300];
    int ret;
    printf("###08\n");
    
    while (true) {
        //ret = sock.receive(buffer, sizeof(buffer)-1);
        ret = clt_sock.recv(buffer, sizeof(buffer));
        printf("###09\n");
        
        if (ret <= 0)
            break;
            
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
        printf("###11\n");
    }
      
    //sock.close();
    printf("###12\n");
    
    //eth.disconnect();
    printf("###13\n");
    
    delete buffer;
    delete http_cmd;
    printf("###14\n");
}

void NetworkManager::threadCheckConnectServer() {
    Thread threadWM;
    threadWM.start(CheckConnectServer);
}*/