#include "module_for_all.h"

IR_Manager::IR_Manager()
{
    /*DigitalIn isIR_1(PG_8);
    DigitalIn isIR_2(PF_11);
    DigitalIn isIR_3(PG_5);
    DigitalIn isIR_4(PG_6);
    DigitalIn isIR_5(PE_0);
    DigitalIn isIR_6(PF_15);*/

    /*isIR_1 = DigitalIn(PG_8);
    isIR_2 = DigitalIn(PF_11);
    isIR_3 = DigitalIn(PG_5);
    isIR_4 = DigitalIn(PG_6);
    isIR_5 = DigitalIn(PE_0);
    isIR_6 = DigitalIn(PF_15);
    isIR = {
        &isIR_1,
        &isIR_2,
        &isIR_3,
        &isIR_4,
        &isIR_5,
        &isIR_6};

    //&(AnalogIn(PF_6)), &(AnalogIn(PF_7)), &(AnalogIn(PA_0))
    ainIR_11 = AnalogIn(PF_6);
    ainIR_12 = AnalogIn(PF_7);
    ainIR_13 = AnalogIn(PA_0);
    //&(AnalogIn(PB_1)), &(AnalogIn(PF_5)), &(AnalogIn(PF_4))
    ainIR_21 = AnalogIn(PB_1);
    ainIR_22 = AnalogIn(PF_5);
    ainIR_23 = AnalogIn(PF_4);
    //&(AnalogIn(PC_2)), &(AnalogIn(PC_3)), &(AnalogIn(PA_4))
    ainIR_31 = AnalogIn(PC_2);
    ainIR_32 = AnalogIn(PC_3);
    ainIR_33 = AnalogIn(PA_4);
    //&(AnalogIn(PC_0)), &(AnalogIn(PF_8)), &(AnalogIn(PF_9))
    ainIR_41 = AnalogIn(PC_0);
    ainIR_42 = AnalogIn(PF_8);
    ainIR_43 = AnalogIn(PF_9);
    //&(AnalogIn(PA_3)), &(AnalogIn(PF_10)), &(AnalogIn(PF_3))
    ainIR_51 = AnalogIn(PA_3);
    ainIR_52 = AnalogIn(PF_10);
    ainIR_53 = AnalogIn(PF_3);
    //&(AnalogIn(PA_5)), &(AnalogIn(PA_6)), 0
    ainIR_61 = AnalogIn(PA_5);
    ainIR_62 = AnalogIn(PA_6);

    ainIR = {
        {&ainIR_11, &ainIR_12, &ainIR_13},
        {&ainIR_21, &ainIR_22, &ainIR_23},
        {&ainIR_31, &ainIR_32, &ainIR_33},
        {&ainIR_41, &ainIR_42, &ainIR_43},
        {&ainIR_51, &ainIR_52, &ainIR_53},
        {&ainIR_61, &ainIR_62, 0}
    };*/

    /*isIR[6] = {
        &(DigitalIn(PG_8)),
        &(DigitalIn(PF_11)),
        &(DigitalIn(PG_5)),
        &(DigitalIn(PG_6)),
        &(DigitalIn(PE_0)),
        &(DigitalIn(PF_15))};

    ainIR[6][3] = {
        {&(AnalogIn(PF_6)), &(AnalogIn(PF_7)), &(AnalogIn(PA_0))},
        {&(AnalogIn(PB_1)), &(AnalogIn(PF_5)), &(AnalogIn(PF_4))},
        {&(AnalogIn(PC_2)), &(AnalogIn(PC_3)), &(AnalogIn(PA_4))},
        {&(AnalogIn(PC_0)), &(AnalogIn(PF_8)), &(AnalogIn(PF_9))},
        {&(AnalogIn(PA_3)), &(AnalogIn(PF_10)), &(AnalogIn(PF_3))},
        {&(AnalogIn(PA_5)), &(AnalogIn(PA_6)), 0}};*/
}

IR_Manager::IR_Manager(std::string tmpStr)
{
    /*isIR_1 = DigitalIn(PG_8);
    isIR_2 = DigitalIn(PF_11);
    isIR_3 = DigitalIn(PG_6);
    isIR_4 = DigitalIn(PG_6);
    isIR_5 = DigitalIn(PE_0);
    isIR_6 = DigitalIn(PF_15);
    isIR = {
        &isIR_1,
        &isIR_2,
        &isIR_3,
        &isIR_4,
        &isIR_5,
        &isIR_6};

    //&(AnalogIn(PF_6)), &(AnalogIn(PF_7)), &(AnalogIn(PA_0))
    ainIR_11 = AnalogIn(PF_6);
    ainIR_12 = AnalogIn(PF_7);
    ainIR_13 = AnalogIn(PA_0);
    //&(AnalogIn(PB_1)), &(AnalogIn(PF_5)), &(AnalogIn(PF_4))
    ainIR_21 = AnalogIn(PB_1);
    ainIR_22 = AnalogIn(PF_5);
    ainIR_23 = AnalogIn(PF_4);
    //&(AnalogIn(PC_2)), &(AnalogIn(PC_3)), &(AnalogIn(PA_4))
    ainIR_31 = AnalogIn(PC_2);
    ainIR_32 = AnalogIn(PC_3);
    ainIR_33 = AnalogIn(PA_4);
    //&(AnalogIn(PC_0)), &(AnalogIn(PF_8)), &(AnalogIn(PF_9))
    ainIR_41 = AnalogIn(PC_0);
    ainIR_42 = AnalogIn(PF_8);
    ainIR_43 = (AnalogIn(PF_9);
    //&(AnalogIn(PA_3)), &(AnalogIn(PF_10)), &(AnalogIn(PF_3))
    ainIR_51 = AnalogIn(PA_3);
    ainIR_52 = AnalogIn(PF_10);
    ainIR_53 = (AnalogIn(PF_3);
    //&(AnalogIn(PA_5)), &(AnalogIn(PA_6)), 0
    ainIR_61 = AnalogIn(PA_5);
    ainIR_62 = AnalogIn(PA_6);

    ainIR = {
        {&ainIR_11, &ainIR_12, &ainIR_13},
        {&ainIR_21, &ainIR_22, &ainIR_23},
        {&ainIR_31, &ainIR_32, &ainIR_33},
        {&ainIR_41, &ainIR_42, &ainIR_43},
        {&ainIR_51, &ainIR_52, &ainIR_53},
        {&ainIR_61, &ainIR_62, 0}
    };*/

    /*isIR[6] = {
        &(DigitalIn(PG_8)),
        &(DigitalIn(PF_11)),
        &(DigitalIn(PG_5)),
        &(DigitalIn(PG_6)),
        &(DigitalIn(PE_0)),
        &(DigitalIn(PF_15))};

    ainIR[6][3] = {
        {&(AnalogIn(PF_6)), &(AnalogIn(PF_7)), &(AnalogIn(PA_0))},
        {&(AnalogIn(PB_1)), &(AnalogIn(PF_5)), &(AnalogIn(PF_4))},
        {&(AnalogIn(PC_2)), &(AnalogIn(PC_3)), &(AnalogIn(PA_4))},
        {&(AnalogIn(PC_0)), &(AnalogIn(PF_8)), &(AnalogIn(PF_9))},
        {&(AnalogIn(PA_3)), &(AnalogIn(PF_10)), &(AnalogIn(PF_3))},
        {&(AnalogIn(PA_5)), &(AnalogIn(PA_6)), 0}};*/
}

void IR_Manager::digitalTest()
{
    //int tmp = isIR[0]->read();
    //printf("###### IR_Manager::digitalTest  %d\r\n", tmp);

    for (int ii = 0; ii < 6; ii++)
        printf("###### IR_Manager::digitalTest ## %d ## %d\r\n", ii, DataStorage::isIR[ii]->read());
}

void IR_Manager::analogTest()
{
    //int tmp = isIR[0]->read();
    //printf("###### IR_Manager::digitalTest  %d\r\n", tmp);

    printf("###### IR_Manager::analogTest ## Start\r\n");
    for (int ii = 0; ii < 6; ii++)
    {
        for (int jj = 0; jj < 3; jj++)
        {
            float ainTmp = 0;
            if (ii == 5 && jj == 2)
            {
                ainTmp = 0;
            }
            else
            {
                ainTmp = DataStorage::ainIR[ii][jj]->read();
                ainTmp = ainTmp * 1000000 * 100;
                ainTmp = floor(ainTmp);
            }

            std::string ainStr = intToString(ainTmp);

            //char *tmpS;
            //sprintf(tmpS, "%12.0f%\r\n", ainTmp);
            //std::string tmpS2(tmpS);

            //printf("###### IR_Manager::analogTest ## %d, %d ## %f ## %s\r\n", ii, jj, ainTmp, ainStr);
            //delete tmpS;
        }
    }
    printf("###### IR_Manager::analogTest ## Over\r\n");
}

std::string IR_Manager::getAnalogStr(int ii, int averageCount)
{
    //int tmp = isIR[0]->read();
    //printf("###### IR_Manager::digitalTest  %d\r\n", tmp);
    std::string resultStr = "";

    if (ii > 5)
        return resultStr;
    for (int jj = 0; jj < 3; jj++)
    {
        float ainTmp = 0;
        float ainCount = float(averageCount);

        if (ii == 5 && jj == 2)
        {
            ainTmp = 0;
        }
        else
        {
            for (int kk = 0; kk < averageCount; kk++)
            {
                float ainTmp2 = 0;
                ainTmp2 = DataStorage::ainIR[ii][jj]->read();
                ainTmp2 = ainTmp2 * 1000000 * 100 / ainCount;
                ainTmp2 = floor(ainTmp2);
                ainTmp += ainTmp2;
            }
        }

        std::string ainStr = intToString(ainTmp);
        resultStr.append(ainStr);
        if (jj != 2)
            resultStr.append(";");
    }
    return resultStr;
}