#ifndef DATASTORAGE_H
#define DATASTORAGE_H

#include "module_for_all.h"

class DataStorage
{
  public:
    DataStorage();
    DataStorage(std::string);

    static bool isAccept;
    static int noAcceptCount;
    static bool isNoConnectServer;

    static int ipSelect;
    static char *ipChar;
    static std::string ipStr;
    static bool isTestMode;

    static std::string http_method;
    static std::string api_command;
    static std::string response;

    //int* WM_PWM;
    //int (*WM_PWM)[2];
    static int WM_PWM[5][2];

    static DigitalOut _W1_A;
    static DigitalOut _W1_B;
    //static DigitalIn  _W1_Ai;
    //static DigitalIn  _W1_Bi;

    static DigitalOut _W2_A;
    static DigitalOut _W2_B;
    static DigitalOut _W3_A;
    static DigitalOut _W3_B;
    static DigitalOut _W4_A;
    static DigitalOut _W4_B;
    static DigitalOut *WM_Control_out[4][2];

    static PwmOut _WM_PWM_out01;
    static PwmOut _WM_PWM_out02;
    static PwmOut _WM_PWM_out03;
    static PwmOut _WM_PWM_out04;
    static PwmOut *WM_PWM_out[4];

    static DigitalIn *isIR[6];
    static DigitalIn isIR_1;
    static DigitalIn isIR_2;
    static DigitalIn isIR_3;
    static DigitalIn isIR_4;
    static DigitalIn isIR_5;
    static DigitalIn isIR_6;

    static AnalogIn *ainIR[6][3];
    static AnalogIn ainIR_11;
    static AnalogIn ainIR_12;
    static AnalogIn ainIR_13;

    static AnalogIn ainIR_21;
    static AnalogIn ainIR_22;
    static AnalogIn ainIR_23;

    static AnalogIn ainIR_31;
    static AnalogIn ainIR_32;
    static AnalogIn ainIR_33;

    static AnalogIn ainIR_41;
    static AnalogIn ainIR_42;
    static AnalogIn ainIR_43;

    static AnalogIn ainIR_51;
    static AnalogIn ainIR_52;
    static AnalogIn ainIR_53;

    static AnalogIn ainIR_61;
    static AnalogIn ainIR_62;

    /* Define function */
    //void setConfig_PWM(PwmOut**, int[5][2]);
    //int get_testInt1();

    void set_PWM_write(int, float);
    void set_PWM_period(int, float);
    static void set_PWM_status(int, int, int);

  private:
    int _moveDirection; //1~16
};

#endif