#include "mbed.h"
#include "Adafruit_ADS1015.h"
#include "USBSerial.h"

#define SERIAL_BAUD_RATE    9600

I2C i2c(p23, p18);
Adafruit_ADS1015 ads(&i2c);
USBSerial pc; // USB CDC serial port

 
int main(){
    ads.setGain(GAIN_SIXTEEN); // set range to +/-0.256V
    int reading;
    while (1) {
        reading = ads.readADC_SingleEnded(0); // read channel 0
        pc.printf("reading: %d\r\n", reading); // print reading
        wait(2); // loop 2 sek
        reading = ads.readADC_Differential_2_3();
        pc.printf("diff a2, a3: %d\r\n", reading); // print diff
    }
}