#include "mbed.h"
#include "HIDScope.h"
#include "encoder.h"

Encoder motor1(D13,D12);
PwmOut led(D9);
HIDScope scope(1);

DigitalOut motor_direction(D4);
PwmOut motor_speed(D5);

DigitalIn button_1(PTC6); //counterclockwise
DigitalIn button_2(PTA4); //clockwise

const int pressed = 0;


void move_motor_ccw (){
    motor_direction = 0;
    motor_speed = 1;
    }
    
void move_motor_cw (){
    motor_direction = 1;
    motor_speed = 0.1;
    }

int main()
{
    scope.set(0,motor1.getPosition());
    
    while (true) {
     
        if (button_1 == pressed){
            move_motor_cw ();
            }
        else if (button_2 == pressed){
            move_motor_ccw ();
            }
        else { 
            motor_speed = 0;
            }
        
        led.write(motor1.getPosition()/100.0);
        scope.send();
        wait(0.2f);
        
    }
}