/**************************************************
 *           Cubiscan  Emulator                   *
 *                   Montra                       *
 * Author: Arturo Alvarado Troncoso               *
 * junio del 2016                                 *
 **************************************************/

#include "mbed.h"
#include "PinDetect.h"
#include "Time.h"
//Constants definition
#define STX  2
#define ETX  3
#define CR   13
#define LF   10

//Pc serial connection
Serial pc(USBTX,USBRX);
PinDetect measureBtn(PTD4);
PinDetect dimBtn(PTA12);
PinDetect wBtn(PTA4);
PinDetect ErrorBtn(PTA5);
//DIP SWITCH
DigitalIn Dip1(PTC13);//CubiScan 100L
DigitalIn Dip2(PTC12);//CubiScan 125
DigitalIn Dip3(PTC11);//CubiScan 150
DigitalIn Dip4(PTC10);//CubiScan 200TS protocol 1
DigitalIn Dip5(PTC6);//CubiScan 200TS protocol 2
DigitalIn Dip6(PTC5);
DigitalIn Dip7(PTC4);
DigitalIn Dip8(PTC3);

char dimUnitsValue = 'M';
char wUnitsValue = 'M';
char factor = 'D';//dom 166 int 139 lb 6000 iny 5000 kg
char id[7]="      ";
int MeasureNumber=0;
int ErrorNum =0;
//Funtions prototypes
int Cycle=0;
Ticker tick;
void dimensionCalibration(char* command);
char dimensionUnits(char* command);
char factorToggle(char* command);
void locationId(char* command);
void measure(char* command);
void scaleCalibration(char* command);
void test(char* command);
void units(char* command);
void values(char* command);
char weightUnits(char* command);
void zero(char* commmand);
void measureCom(void);
void measureCom2(void);
void measureCom2TS(void);
void itoa(int n,char s[]);
void printString(char * str);
void changeWUnits(void);
void changeDUnits(void);
void ErrorGen(void);
void measureCom2Cycle(void){
    if(Cycle == 0){
        Cycle=1;
        tick.attach(&measureCom2, 3.0);
    }
    else{
        Cycle=0;
        tick.detach();
    }

}
int main()
{

    time_t t;
    srand((unsigned) time(&t));
    char command[12];
    measureBtn.setSampleFrequency();
    dimBtn.setSampleFrequency();
    wBtn.setSampleFrequency();
    ErrorBtn.setSampleFrequency();

    while(1) {
        if((!Dip1)||(!Dip2)||(!Dip3)) {
            measureBtn.attach_asserted(&measureCom);
            wBtn.attach_asserted(&changeWUnits);
            dimBtn.attach_asserted(&changeDUnits);
            strcpy(command,"");
            fgets(command,12,stdin);
            if(command[0]==STX) {

                if(command[1]=='D') {
                    dimensionCalibration(command);
                }//end if
                else if(command[1]=='"') {
                    dimUnitsValue=dimensionUnits(command);
                }//end else if
                else if(command[1]=='F') {
                    factor =  factorToggle(command);
                }//end else if
                else if(command[1]=='L') {
                    locationId(command);
                }//end else if
                else if(command[1]=='M') {
                    measure(command);
                }//end else if
                else if(command[1]=='S') {
                    scaleCalibration(command);
                }//end else if
                else if(command[1]=='T') {
                    test(command);

                } else if(command[1]=='U') {
                    units(command);

                }//end if
                else if(command[1]=='V') {
                    values(command);

                }//end if
                else if(command[1]=='#') {
                    wUnitsValue= weightUnits(command);

                }//end if
                else if(command[1]=='Z') {
                    zero(command);

                }///end if

            }//end if

        }//end if
        else if(!Dip4) {
            measureBtn.attach_asserted(&measureCom2Cycle);
            wBtn.attach_asserted(&changeWUnits);
            dimBtn.attach_asserted(&changeDUnits);
            ErrorBtn.attach_asserted(&ErrorGen);
        } else if(!Dip5) {
            measureBtn.attach_asserted(&measureCom2TS);
            wBtn.attach_asserted(&changeWUnits);
            dimBtn.attach_asserted(&changeDUnits);
            ErrorBtn.attach_asserted(&ErrorGen);

        }
    }//end while
}//end main


/*********************************************************
*                                                        *
*                Command Functions                       *
*                                                        *
**********************************************************/
/*
*Dimension Calibration
*
*This function is required when one of the sensors is replaced or
*moved, when a new controller is intalled , or for routine calibration.
*This command causes the CubiScan to reply with a dimension calibratopn codea each time it s issued.
*This command must be issued SIX time to complete sensor calibration.
*/
void dimensionCalibration(char* command)
{
    char respond[9]= {' '};

    if(command[2]== ETX) {
        respond[0]= STX;
        respond[1]= 'D';
        respond[2]='A';
        respond[3]='0';
        respond[4]='0';
        respond[5]= ETX;
        respond[6]=CR;
        respond[7]=LF;
        respond[8]='\0';
    } else {
        respond[0]=STX;
        respond[1]='D';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
    }
    printString(respond);
}//end dimensionCalibration


/*
*Dimension Units
*
*This command is used to set the dimension units to either English(inches)
*or metric (centimeters) mode.
*
*/
char dimensionUnits(char* command)
{
    char respond[7];
    char newUnits;
    if((command[3]== ETX)&&(command[4]== CR)&&(command[5]== LF)&&((command[2]=='M')||(command[2]=='E'))) {
        respond[0]=STX;
        respond[1]='"';
        respond[2]='A';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
        newUnits = command[2];
    }//end if
    else {
        respond[0]=STX;
        respond[1]='"';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
        newUnits = dimUnitsValue;
    }//end else

    printString(respond);
    return newUnits;
}//end dimensionUnits


/*
*Factor Toggle
*
*This command is used to set the dimensional factor to either
*domestic or international.
*/
char factorToggle(char* command)
{
    char respond[7];
    int newFactor;
    if((command[3]== ETX)&&(command[4]== CR)&&(command[5]== LF)&&((command[2]=='I')||(command[2]=='D'))) {
        respond[0]=STX;
        respond[1]='F';
        respond[2]='A';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';

        newFactor=command[2];

    }//end if
    else {
        respond[0]=STX;
        respond[1]='F';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';

        newFactor = factor;
    }//end else
    pc.puts(respond);
    return newFactor;

}//end factorToggle

/*
*Location Id/City Code
*
*This command is used to set the CubiScan location identification.
*This data is stored in permanent memory and need only be set once
*for each Cubiscan
*/
void locationId(char* command)
{
    char respond[7];
    if((command[8]== ETX)&&(command[9]== CR)&&(command[10]== LF)) {
        respond[0]=STX;
        respond[1]='L';
        respond[2]='A';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';

        id[0]=command[2];
        id[1]=command[3];
        id[2]=command[4];
        id[3]=command[5];
        id[4]=command[6];
        id[5]=command[7];

    }//end if
    else {
        respond[0]=STX;
        respond[1]='L';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';


    }//end else
    printString(respond);

}//end locationId

void measure(char*  command)
{
    char medidasCm[5][4]= {{'1','0','0','0'},{' ','9','8','2'},
        {' ',' ','8','3'},{' ','3','4','8'},
        {' ','7','6','4'}
    };
    char medidasIn[5][4]= {{' ','3','9','3'},{' ','3','8','6'},
        {' ',' ','3','3'},{' ','1','3','7'},
        {' ','3','0','0'}
    };
    char pesoLb[6][5]= {{'1','5','0','0','0'},{' ','7','9','1','5'},
        {' ','6','3','2','5'}
    };

    char pesoKg[3][5]= {{' ','6','8','0','3'},{' ','3','5','9','0'},
        {' ','2','8','6','8'}
    };

    char dimLbD[3][5]= {{' ','2','9','7','6'},{' ','1','0','4','0'},{' ',' ','8','0','9'}};
    char dimLbI[3][5]= {{' ','3','6','3','7'},{' ','1','3','2','2'},{' ',' ','9','9','2'}};

    char dimKgD[3][5]= {{' ','1','3','5','0'},{' ',' ','4','7','2'},{' ',' ','3','6','7'}};
    char dimKgI[3][5]= {{' ','1','6','5','0'},{' ',' ','6','0','0'},{' ',' ','4','5','0'}};
    int token = rand()%2;
    char respond[63]= {' '};
    if(command[2]==ETX) {
        respond[0]=STX;
        respond[1]='M';
        respond[2]='A';
        respond[3]='H';
        respond[4]=id[0];
        respond[5]=id[1];
        respond[6]=id[2];
        respond[7]=id[3];
        respond[8]=id[4];
        respond[9]=id[5];
        respond[10]=',';
        if(dimUnitsValue=='E') {
            respond[11]='L';
            respond[12]=medidasIn[token][0];
            respond[13]=medidasIn[token][1];
            respond[14]=medidasIn[token][2];
            respond[15]='.';
            respond[16]=medidasIn[token][3];
            respond[17]=',';
            respond[18]='W';
            respond[19]=medidasIn[token+1][0];
            respond[20]=medidasIn[token+1][1];
            respond[21]=medidasIn[token+1][2];
            respond[22]='.';
            respond[23]=medidasIn[token+1][3];
            respond[24]=',';
            respond[25]='H';
            respond[26]=medidasIn[token+2][0];
            respond[27]=medidasIn[token+2][1];
            respond[28]=medidasIn[token+2][2];
            respond[29]='.';
            respond[30]=medidasIn[token+2][3];
        } else {
            respond[11]='L';
            respond[12]=medidasCm[token][0];
            respond[13]=medidasCm[token][1];
            respond[14]=medidasCm[token][2];
            respond[15]='.';
            respond[16]=medidasCm[token][3];
            respond[17]=',';
            respond[18]='W';
            respond[19]=medidasCm[token+1][0];
            respond[20]=medidasCm[token+1][1];
            respond[21]=medidasCm[token+1][2];
            respond[22]='.';
            respond[23]=medidasCm[token+1][3];
            respond[24]=',';
            respond[25]='H';
            respond[26]=medidasCm[token+2][0];
            respond[27]=medidasCm[token+2][1];
            respond[28]=medidasCm[token+2][2];
            respond[29]='.';
            respond[30]=medidasCm[token+2][3];
        }
        if(wUnitsValue=='E') {
            respond[31]=',';
            respond[32]=dimUnitsValue;
            respond[33]=',';
            respond[34]='K';
            respond[35]=pesoLb[token][0];
            respond[36]=pesoLb[token][1];
            respond[37]=pesoLb[token][2];
            respond[38]='.';
            respond[39]=pesoLb[token][3];
            respond[40]=pesoLb[token][4];
            respond[41]=',';
            if(factor=='D') {
                respond[42]='D';
                respond[43]=dimLbD[token][0];
                respond[44]=dimLbD[token][1];
                respond[45]=dimLbD[token][2];
                respond[46]='.';
                respond[47]=dimLbD[token][3];
                respond[48]=dimLbD[token][4];
                respond[49]=',';
                respond[50]=wUnitsValue;
                respond[51]=',';
                respond[52]='F';
                respond[53]=' ';
                respond[54]='1';
                respond[55]='6';
                respond[56]='6';
                respond[57]=',';
            } else {
                respond[42]='D';
                respond[43]=dimLbI[token][0];
                respond[44]=dimLbI[token][1];
                respond[45]=dimLbI[token][2];
                respond[46]='.';
                respond[47]=dimLbI[token][3];
                respond[48]=dimLbI[token][4];
                respond[49]=',';
                respond[50]=wUnitsValue;
                respond[51]=',';
                respond[52]='F';
                respond[53]=' ';
                respond[54]='1';
                respond[55]='3';
                respond[56]='9';
                respond[57]=',';
            }
        } else {
            respond[31]=',';
            respond[32]=dimUnitsValue;
            respond[33]=',';
            respond[34]='K';
            respond[35]=pesoKg[token][0];
            respond[36]=pesoKg[token][1];
            respond[37]=pesoKg[token][2];
            respond[38]='.';
            respond[39]=pesoKg[token][3];
            respond[40]=pesoKg[token][4];
            respond[41]=',';
            if(factor=='D') {
                respond[42]='D';
                respond[43]=dimKgD[token][0];
                respond[44]=dimKgD[token][1];
                respond[45]=dimKgD[token][2];
                respond[46]='.';
                respond[47]=dimKgD[token][3];
                respond[48]=dimKgD[token][4];
                respond[49]=',';
                respond[50]=wUnitsValue;
                respond[51]=',';
                respond[52]='F';
                respond[53]='6';
                respond[54]='0';
                respond[55]='0';
                respond[56]='0';
                respond[57]=',';
            } else {
                respond[42]='D';
                respond[43]=dimKgI[token][0];
                respond[44]=dimKgI[token][1];
                respond[45]=dimKgI[token][2];
                respond[46]='.';
                respond[47]=dimKgI[token][3];
                respond[48]=dimKgI[token][4];
                respond[49]=',';
                respond[50]=wUnitsValue;
                respond[51]=',';
                respond[52]='F';
                respond[53]='5';
                respond[54]='0';
                respond[55]='0';
                respond[56]='0';
                respond[57]=',';
            }
        }
        respond[58]=factor;
        respond[59]=ETX;
        respond[60]=CR;
        respond[61]=LF;
        respond[62]='\0';
    }//end if
    else {
        respond[0] = STX;
        respond[1] = 'M';
        respond[2] = 'N';
        respond[3] = 'H';
        respond[4] = 'M';
        respond[5] = ETX;
        respond[6] = CR;
        respond[7] = LF;
        respond[8] = '\0';
    }//end else
    printString(respond);
}//end measure


/*
*Scale Calibration
*
*This fuction is requiered when the load cell s replaced,
*when a new controller is installed, or for routine calibration.
*This command causes the CubiScan to reply with a scale calibration code.
*This command must be issued THREE times to complete scale calibration.
*/
void scaleCalibration(char* command)
{
    char respond[8];
    if((command[2]== ETX)&&(command[3]== CR)&&(command[4]== LF)) {
        respond[0]=STX;
        respond[1]='S';
        respond[2]='A';
        respond[3]='0';
        respond[4]='0';
        respond[5]= ETX;
        respond[6]=CR;
        respond[7]=LF;
    } else {
        respond[0]=STX;
        respond[1]='S';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
    }
    printString(respond);
}//end scaleCalibration

/*
*Test
*
*This command couses the CubiScan to reply with an error code.
*A response of TA00 means that the CubiScan is ready and responding t transmission from the host.
*if the host recieves no response from the contro unit after sendingg this command,
*an error condition exists in the communications etween the host and the controller.
*/
void test(char* command)
{
    char respond[9];
    if((command[2]== ETX)&&(command[3]== CR)&&(command[4]== LF)) {
        respond[0]=STX;
        respond[1]='T';
        respond[2]='A';
        respond[3]='0';
        respond[4]='0';
        respond[5]= ETX;
        respond[6]=CR;
        respond[7]=LF;
        respond[8]='\0';
    } else {
        respond[0]=STX;
        respond[1]='T';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
    }
    //pc.puts(respond);
    printString(respond);
}//end test



/*
*Units
*
*This command causes the CubiScan to repot its
*current modes of operation.
*/
void units(char* command)
{
    char respond[20];
    if((command[2]== ETX)&&(command[3]== CR)&&(command[4]== LF)) {
        if(factor=='D') {
            respond[0]=STX;
            respond[1]='U';
            respond[2]='A';
            respond[3]=dimUnitsValue;
            respond[4]=wUnitsValue;
            respond[5]='D';
            respond[6]=' ';
            respond[7]='1';
            respond[8]='6';
            respond[9]='6';
            respond[10]=id[0];
            respond[11]=id[1];
            respond[12]=id[2];
            respond[13]=id[3];
            respond[14]=id[4];
            respond[15]=id[5];
            respond[16]=ETX;
            respond[17]=CR;
            respond[18]=LF;
            respond[19]='\0';
        } else {
            respond[0]=STX;
            respond[1]='U';
            respond[2]='A';
            respond[3]=dimUnitsValue;
            respond[4]=wUnitsValue;
            respond[5]='I';
            respond[6]=' ';
            respond[7]='1';
            respond[8]='3';
            respond[9]='9';
            respond[10]=id[0];
            respond[11]=id[1];
            respond[12]=id[2];
            respond[13]=id[3];
            respond[14]=id[4];
            respond[15]=id[5];
            respond[16]=ETX;
            respond[17]=CR;
            respond[18]=LF;
            respond[19]='\0';

        }
    } else {
        respond[0]=STX;
        respond[1]='U';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
    }
    printString(respond);
}//end units

/**
*Values
*
*This command causes the CubiScan to report all of itrs internal
*paraneters. This is useful for troubleshooting.
*/
void values(char* command)
{
    char respond[157];
    if((command[2]== ETX)&&(command[3]== CR)&&(command[4]== LF)) {
        respond[0]=STX;
        respond[1]='V';
        respond[2]='A';
        respond[3]='0';
        respond[4]='0';
        respond[5]='.';
        respond[6]='0';
        respond[7]=',';
        respond[8]='0';
        respond[9]='0';
        respond[10]='.';
        respond[11]='0';
        respond[12]=',';
        respond[13]='0';
        respond[14]='0';
        respond[15]='.';
        respond[16]='0';
        respond[17]=',';
        respond[18]='0';
        respond[19]='0';
        respond[20]='.';
        respond[21]='0';
        respond[22]=',';
        respond[23]='0';
        respond[24]='0';
        respond[25]='0';
        respond[26]='0';
        respond[27]=',';
        respond[28]='0';
        respond[29]='0';
        respond[30]='0';
        respond[31]='0';
        respond[32]=',';
        respond[33]='0';
        respond[34]='0';
        respond[35]='0';
        respond[36]='0';
        respond[37]=',';
        respond[38]='0';
        respond[39]='0';
        respond[40]='0';
        respond[41]='0';
        respond[42]=',';
        respond[43]='0';
        respond[44]='0';
        respond[45]='.';
        respond[46]='0';
        respond[47]=',';
        respond[48]='0';
        respond[49]='0';
        respond[50]='.';
        respond[51]='0';
        respond[52]=',';
        respond[53]='0';
        respond[54]='0';
        respond[55]='.';
        respond[56]='0';
        respond[57]=',';
        respond[58]='0';
        respond[59]='0';
        respond[60]='.';
        respond[61]='0';
        respond[62]=',';
        respond[63]='0';
        respond[64]='0';
        respond[65]='.';
        respond[66]='0';
        respond[67]=',';
        respond[68]='0';
        respond[69]='0';
        respond[70]='.';
        respond[71]='0';
        respond[72]=',';
        respond[73]='0';
        respond[74]='0';
        respond[75]='.';
        respond[76]='0';
        respond[77]=',';
        respond[78]='0';
        respond[79]='0';
        respond[80]='.';
        respond[81]='0';
        respond[82]=',';
        respond[83]='0';
        respond[84]='0';
        respond[85]=',';
        respond[86]='0';
        respond[87]='0';
        respond[88]=',';
        respond[89]='0';
        respond[90]='0';
        respond[91]=',';
        respond[92]='0';
        respond[93]='0';
        respond[94]=',';
        respond[95]='0';
        respond[96]='0';
        respond[97]='0';
        respond[98]=',';
        respond[99]='0';
        respond[100]='0';
        respond[101]='0';
        respond[102]=',';
        respond[103]='0';
        respond[104]='0';
        respond[105]='0';
        respond[106]=',';
        respond[107]='0';
        respond[108]='0';
        respond[109]='0';
        respond[110]=',';
        respond[111]='1';
        respond[112]='0';
        respond[113]='0';
        respond[114]='L';
        respond[115]=',';
        respond[116]='1';
        respond[117]='0';
        respond[118]='0';
        respond[119]=',';
        respond[120]='1';
        respond[121]='.';
        respond[122]='0';
        respond[123]='0';
        respond[124]='0';
        respond[125]=' ';
        respond[126]=' ';
        respond[127]=' ';
        respond[128]=' ';
        respond[129]=' ';
        respond[130]=' ';
        respond[131]=' ';
        respond[132]=' ';
        respond[133]=' ';
        respond[134]=' ';
        respond[135]=' ';
        respond[136]=' ';
        respond[137]=' ';
        respond[138]=' ';
        respond[139]=' ';
        respond[140]=' ';
        respond[141]=' ';
        respond[142]=' ';
        respond[143]=' ';
        respond[144]=' ';
        respond[145]=' ';
        respond[146]=' ';
        respond[147]=' ';
        respond[148]=' ';
        respond[149]=' ';
        respond[150]=' ';
        respond[151]=' ';
        respond[152]=' ';
        respond[153]=ETX;
        respond[154]=CR;
        respond[155]=LF;
        respond[156]='\0';

    } else {
        respond[0]=STX;
        respond[1]='V';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
    }
    printString(respond);

}//end values


/**
*Weight Units
*
*This command is used to set the weight units to either English
*(pounds) or metric (kilograms) mode.
*
*/
char weightUnits(char* command)
{
    char respond[7];
    char newUnits;
    if((command[3]== ETX)&&(command[4]== CR)&&(command[5]== LF)&&((command[2]=='M')||(command[2]=='E'))) {
        respond[0]=STX;
        respond[1]='#';
        respond[2]='A';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
        newUnits = command[2];
    }//end if
    else {
        respond[0]=STX;
        respond[1]='#';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
        newUnits = wUnitsValue;
    }//end else
    printString(respond);
    return newUnits;
}//end weightUnits


/*
*Zero
*
*This command should be issued periodically to force the CubiScan
*to perform interal compensations to adjust to changes in temperature
*and humidity. This command should onlu be issued when the measuring field is free of packages.
*Never issue this command when a pacage is present in the measuring field.
*
*/

void zero(char* command)
{
    char respond[7];
    if((command[2]== ETX)&&(command[3]== CR)&&(command[4]== LF)) {
        respond[0]=STX;
        respond[1]='Z';
        respond[2]='A';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
    }//end if
    else {
        respond[0]=STX;
        respond[1]='Z';
        respond[2]='N';
        respond[3]=ETX;
        respond[4]=CR;
        respond[5]=LF;
        respond[6]='\0';
    }//end else
    printString(respond);
}//end zero

void printString(char * str)
{
    printf("%s",str );
}//end printString


void measureCom()
{
    char medidasCm[5][4]= {{'1','0','0','0'},{' ','9','8','2'},
        {' ',' ','8','3'},{' ','3','4','8'},
        {' ','7','6','4'}
    };
    char medidasIn[5][4]= {{' ','3','9','3'},{' ','3','8','6'},
        {' ',' ','3','3'},{' ','1','3','7'},
        {' ','3','0','0'}
    };
    char pesoLb[6][5]= {{'1','5','0','0','0'},{' ','7','9','1','5'},
        {' ','6','3','2','5'}
    };

    char pesoKg[3][5]= {{' ','6','8','0','3'},{' ','3','5','9','0'},
        {' ','2','8','6','8'}
    };

    char dimLbD[3][5]= {{' ','2','9','7','6'},{' ','1','0','4','0'},{' ',' ','8','0','9'}};
    char dimLbI[3][5]= {{' ','3','6','3','7'},{' ','1','3','2','2'},{' ',' ','9','9','2'}};

    char dimKgD[3][5]= {{' ','1','3','5','0'},{' ',' ','4','7','2'},{' ',' ','3','6','7'}};
    char dimKgI[3][5]= {{' ','1','6','5','0'},{' ',' ','6','0','0'},{' ',' ','4','5','0'}};
    int token = rand()%2;
    char respond[63]= {' '};
    respond[0]=STX;
    respond[1]='M';
    respond[2]='A';
    respond[3]='H';
    respond[4]=id[0];
    respond[5]=id[1];
    respond[6]=id[2];
    respond[7]=id[3];
    respond[8]=id[4];
    respond[9]=id[5];
    respond[10]=',';
    if(dimUnitsValue=='E') {
        respond[11]='L';
        respond[12]=medidasIn[token][0];
        respond[13]=medidasIn[token][1];
        respond[14]=medidasIn[token][2];
        respond[15]='.';
        respond[16]=medidasIn[token][3];
        respond[17]=',';
        respond[18]='W';
        respond[19]=medidasIn[token+1][0];
        respond[20]=medidasIn[token+1][1];
        respond[21]=medidasIn[token+1][2];
        respond[22]='.';
        respond[23]=medidasIn[token+1][3];
        respond[24]=',';
        respond[25]='H';
        respond[26]=medidasIn[token+2][0];
        respond[27]=medidasIn[token+2][1];
        respond[28]=medidasIn[token+2][2];
        respond[29]='.';
        respond[30]=medidasIn[token+2][3];
    } else {
        respond[11]='L';
        respond[12]=medidasCm[token][0];
        respond[13]=medidasCm[token][1];
        respond[14]=medidasCm[token][2];
        respond[15]='.';
        respond[16]=medidasCm[token][3];
        respond[17]=',';
        respond[18]='W';
        respond[19]=medidasCm[token+1][0];
        respond[20]=medidasCm[token+1][1];
        respond[21]=medidasCm[token+1][2];
        respond[22]='.';
        respond[23]=medidasCm[token+1][3];
        respond[24]=',';
        respond[25]='H';
        respond[26]=medidasCm[token+2][0];
        respond[27]=medidasCm[token+2][1];
        respond[28]=medidasCm[token+2][2];
        respond[29]='.';
        respond[30]=medidasCm[token+2][3];
    }
    if(wUnitsValue=='E') {
        respond[31]=',';
        respond[32]=dimUnitsValue;
        respond[33]=',';
        respond[34]='K';
        respond[35]=pesoLb[token][0];
        respond[36]=pesoLb[token][1];
        respond[37]=pesoLb[token][2];
        respond[38]='.';
        respond[39]=pesoLb[token][3];
        respond[40]=pesoLb[token][4];
        respond[41]=',';
        if(factor=='D') {
            respond[42]='D';
            respond[43]=dimLbD[token][0];
            respond[44]=dimLbD[token][1];
            respond[45]=dimLbD[token][2];
            respond[46]='.';
            respond[47]=dimLbD[token][3];
            respond[48]=dimLbD[token][4];
            respond[49]=',';
            respond[50]=wUnitsValue;
            respond[51]=',';
            respond[52]='F';
            respond[53]=' ';
            respond[54]='1';
            respond[55]='6';
            respond[56]='6';
            respond[57]=',';
        } else {
            respond[42]='D';
            respond[43]=dimLbI[token][0];
            respond[44]=dimLbI[token][1];
            respond[45]=dimLbI[token][2];
            respond[46]='.';
            respond[47]=dimLbI[token][3];
            respond[48]=dimLbI[token][4];
            respond[49]=',';
            respond[50]=wUnitsValue;
            respond[51]=',';
            respond[52]='F';
            respond[53]=' ';
            respond[54]='1';
            respond[55]='3';
            respond[56]='9';
            respond[57]=',';
        }
    } else {
        respond[31]=',';
        respond[32]=dimUnitsValue;
        respond[33]=',';
        respond[34]='K';
        respond[35]=pesoKg[token][0];
        respond[36]=pesoKg[token][1];
        respond[37]=pesoKg[token][2];
        respond[38]='.';
        respond[39]=pesoKg[token][3];
        respond[40]=pesoKg[token][4];
        respond[41]=',';
        if(factor=='D') {
            respond[42]='D';
            respond[43]=dimKgD[token][0];
            respond[44]=dimKgD[token][1];
            respond[45]=dimKgD[token][2];
            respond[46]='.';
            respond[47]=dimKgD[token][3];
            respond[48]=dimKgD[token][4];
            respond[49]=',';
            respond[50]=wUnitsValue;
            respond[51]=',';
            respond[52]='F';
            respond[53]='6';
            respond[54]='0';
            respond[55]='0';
            respond[56]='0';
            respond[57]=',';
        } else {
            respond[42]='D';
            respond[43]=dimKgI[token][0];
            respond[44]=dimKgI[token][1];
            respond[45]=dimKgI[token][2];
            respond[46]='.';
            respond[47]=dimKgI[token][3];
            respond[48]=dimKgI[token][4];
            respond[49]=',';
            respond[50]=wUnitsValue;
            respond[51]=',';
            respond[52]='F';
            respond[53]='5';
            respond[54]='0';
            respond[55]='0';
            respond[56]='0';
            respond[57]=',';
        }
    }
    respond[58]=factor;
    respond[59]=ETX;
    respond[60]=CR;
    respond[61]=LF;
    respond[62]='\0';


    printString(respond);
}//end measureCom

void measureCom2()
{
    // pc.printf("Entro");
    Timer tim;
    char measureNum[5]= {' ',' ',' ',' '};
    char measureNumGap[5]= {' ',' ',' ',' '};
    char medidasCm[5][4]= {{'1','0','0','0'},{' ','9','8','2'},
        {' ',' ','8','3'},{' ','3','4','8'},
        {' ','7','6','4'}
    };
    char medidasIn[5][4]= {{' ','3','9','3'},{' ','3','8','6'},
        {' ',' ','3','3'},{' ','1','3','7'},
        {' ','3','0','0'}
    };
    char pesoLb[6][5]= {{'1','5','0','0','0'},{' ','7','9','1','5'},
        {' ','6','3','2','5'}
    };

    char pesoKg[3][5]= {{' ','6','8','0','3'},{' ','3','5','9','0'},
        {' ','2','8','6','8'}
    };
    int token = rand()%2;
    int token2 =  rand()%3;
    int token3 = rand()%2;
    
    char respond[80]= {' '};
    respond[0]=STX;
    respond[1]='B';
    respond[2]='A';
    itoa(MeasureNumber,measureNum);
    respond[3]=measureNum[3];
    respond[4]=measureNum[2];
    respond[5]=measureNum[1];
    respond[6]=measureNum[0];
    respond[7]=ETX;
    respond[8]=CR;
    respond[9]=LF;
    respond[10]='\0';

    printString(respond);

    wait(2);

    strcpy(respond,"");
    itoa(MeasureNumber+1,measureNumGap);
    respond[0]=STX;
    respond[1]='G';
    respond[2]='A';
    respond[3]=measureNumGap[3];
    respond[4]=measureNumGap[2];
    respond[5]=measureNumGap[1];
    respond[6]=measureNumGap[0];
    respond[7]=ETX;
    respond[8]=CR;
    respond[9]=LF;
    respond[10]='\0';

    printString(respond);
    strcpy(respond,"");

    respond[0]=STX;
    respond[1]='M';
    respond[2]='A';
    respond[3]=measureNum[3];
    respond[4]=measureNum[2];
    respond[5]=measureNum[1];
    respond[6]=measureNum[0];
    respond[7]=',';
    respond[8]=id[0];
    respond[9]=id[1];
    respond[10]=id[2];
    respond[11]=id[3];
    respond[12]=id[4];
    respond[13]=id[5];
    respond[14]=',';
    if(dimUnitsValue=='E') {
        respond[15]='L';
        respond[16]=medidasIn[token][0];
        respond[17]=medidasIn[token][1];
        respond[18]=medidasIn[token][2];
        respond[19]='.';
        respond[20]=medidasIn[token][3];
        respond[21]=',';
        respond[22]='0';
        respond[23]='0';
        respond[24]=',';
        respond[25]='W';
        respond[26]=medidasIn[token+1][0];
        respond[27]=medidasIn[token+1][1];
        respond[28]=medidasIn[token+1][2];
        respond[29]='.';
        respond[30]=medidasIn[token+1][3];
        respond[31]=',';
        respond[32]='0';
        respond[33]='0';
        respond[34]=',';
        respond[35]='H';
        respond[36]=medidasIn[token+2][0];
        respond[37]=medidasIn[token+2][1];
        respond[38]=medidasIn[token+2][2];
        respond[39]='.';
        respond[40]=medidasIn[token+2][3];
        respond[41]=',';
        respond[42]='0';
        respond[43]='0';
        respond[44]=',';
        respond[45]='i';
        respond[46]='n';
        respond[47]=',';
    } else {
        respond[15]='L';
        respond[16]=medidasCm[token][0];
        respond[17]=medidasCm[token][1];
        respond[18]=medidasCm[token][2];
        respond[19]='.';
        respond[20]=medidasCm[token][3];
        respond[21]=',';
        respond[22]='0';
        respond[23]='0';
        respond[24]=',';
        respond[25]='W';
        respond[26]=medidasCm[token+1][0];
        respond[27]=medidasCm[token+1][1];
        respond[28]=medidasCm[token+1][2];
        respond[29]='.';
        respond[30]=medidasCm[token+1][3];
        respond[31]=',';
        respond[32]='0';
        respond[33]='0';
        respond[34]=',';
        respond[35]='H';
        respond[36]=medidasCm[token+2][0];
        respond[37]=medidasCm[token+2][1];
        respond[38]=medidasCm[token+2][2];
        respond[39]='.';
        respond[40]=medidasCm[token+2][3];
        respond[41]=',';
        respond[42]='0';
        respond[43]='0';
        respond[44]=',';
        respond[45]='c';
        respond[46]='m';
        respond[47]=',';
    }
    if(wUnitsValue=='E') {
        respond[48]='M';
        respond[49]=pesoLb[token][0];
        respond[50]=pesoLb[token][1];
        respond[51]=pesoLb[token][2];
        respond[52]='.';
        respond[53]=pesoLb[token][3];
        respond[54]=',';
        respond[55]='0';
        respond[56]='0';
        respond[57]=',';
        respond[58]='l';
        respond[59]='b';
        respond[60]=',';

    } else {

        respond[48]='M';
        respond[49]=pesoKg[token][0];
        respond[50]=pesoKg[token][1];
        respond[51]=pesoKg[token][2];
        respond[52]='.';
        respond[53]=pesoKg[token][3];
        respond[54]=',';
        respond[55]='0';
        respond[56]='0';
        respond[57]=',';
        respond[58]='k';
        respond[59]='g';
        respond[60]=',';
    }

    respond[61]='1';
    respond[62]='2';
    respond[63]='/';
    respond[64]='3';
    respond[65]='1';
    respond[66]='/';
    respond[67]='1';
    respond[68]='6';
    respond[69]=',';
    respond[70]='1';
    respond[71]='2';
    respond[72]=':';
    respond[73]='5';
    respond[74]='9';
    respond[75]='A';
    respond[76]=ETX;
    respond[77]=CR;
    respond[78]=LF;
    respond[79]='\0';
    wait_ms(120);
    if(ErrorNum==1) {
        if(token2==0) {
            respond[16]=' ';
            respond[17]=' ';
            respond[18]='0';
            respond[19]='.';
            respond[20]='0';
            respond[21]=',';
            if(token3==0) {
                respond[22]='0';
                respond[23]='1';
            } else {
                respond[22]='1';
                respond[23]='1';
            }
        } else if(token2==1) {
            respond[26]=' ';
            respond[27]=' ';
            respond[28]='0';
            respond[29]='.';
            respond[30]='0';
            respond[31]=',';
            if(token3==0) {
                respond[32]='0';
                respond[33]='1';
            } else {
                respond[32]='1';
                respond[33]='1';
            }
        } else {
            respond[36]=' ';
            respond[37]=' ';
            respond[38]='0';
            respond[39]='.';
            respond[40]='0';
            respond[41]=',';
            if(token3==0) {
                respond[42]='0';
                respond[43]='1';
            } else {
                respond[42]='1';
                respond[43]='1';
            }
        }
    } else if(ErrorNum==2) {
        respond[49]=' ';
        respond[50]=' ';
        respond[51]='0';
        respond[52]='.';
        respond[53]='0';
        respond[54]=',';
        if(token3==0) {

            respond[55]='0';
            respond[56]='1';
        } else {
            respond[55]='1';
            respond[56]='1';
        }
    }
    printString(respond);
    MeasureNumber++;
}
/* itoa:  convert n to characters in s */
void measureCom2TS(void)
{

    char measureNum[5]= {' ',' ',' ',' '};

    char medidasCm[5][4]= {{'1','0','0','0'},{' ','9','8','2'},
        {' ',' ','8','3'},{' ','3','4','8'},
        {' ','7','6','4'}
    };
    char medidasIn[5][4]= {{' ','3','9','3'},{' ','3','8','6'},
        {' ',' ','3','3'},{' ','1','3','7'},
        {' ','3','0','0'}
    };
    char pesoLb[6][5]= {{' ','1','5','0','0'},{' ',' ','7','9','5'},
        {' ',' ','6','3','5'}
    };

    char pesoKg[3][5]= {{' ',' ','8','0','3'},{' ',' ','5','9','0'},
        {' ',' ','8','6','8'}
    };
    int token = rand()%2;
    int token2 =  rand()%3;
    int token3 = rand()%2;

    char respond[55]= {' '};
    char respond1[7]= {' '};
    respond1[0]=STX;
    respond1[1]='B';
    respond1[2]='A';
    respond1[3]='1';
    respond1[4]='1';
    respond1[5]=ETX;
    respond1[6]='\0';

    //  printString(respond);
    // fputs(respond,stdout);
    strcpy(respond,"");
    itoa(MeasureNumber,measureNum);
    respond[0]=STX;
    respond[1]='A';
    respond[2]=measureNum[3];
    respond[3]=measureNum[2];
    respond[4]=measureNum[1];
    respond[5]=measureNum[0];
    respond[6]='0';
    respond[7]='0';
    if(dimUnitsValue=='E') {
        respond[8]='L';
        respond[9]=medidasIn[token][0];
        respond[10]=medidasIn[token][1];
        respond[11]=medidasIn[token][2];
        respond[12]='.';
        respond[13]=medidasIn[token][3];
        respond[14]='i';
        respond[15]='n';
        respond[16]='0';
        respond[17]='0';
        respond[18]='W';
        respond[19]=medidasIn[token+1][0];
        respond[20]=medidasIn[token+1][1];
        respond[21]=medidasIn[token+1][2];
        respond[22]='.';
        respond[23]=medidasIn[token+1][3];
        respond[24]='i';
        respond[25]='n';
        respond[26]='0';
        respond[27]='0';
        respond[28]='H';
        respond[29]=medidasIn[token+2][0];
        respond[30]=medidasIn[token+2][1];
        respond[31]=medidasIn[token+2][2];
        respond[32]='.';
        respond[33]=medidasIn[token+2][3];
        respond[34]='i';
        respond[35]='n';
        respond[36]='0';
        respond[37]='0';
    } else {
        respond[8]='L';
        respond[9]=medidasCm[token][0];
        respond[10]=medidasCm[token][1];
        respond[11]=medidasCm[token][2];
        respond[12]='.';
        respond[13]=medidasCm[token][3];
        respond[14]='c';
        respond[15]='m';
        respond[16]='0';
        respond[17]='0';
        respond[18]='W';
        respond[19]=medidasCm[token+1][0];
        respond[20]=medidasCm[token+1][1];
        respond[21]=medidasCm[token+1][2];
        respond[22]='.';
        respond[23]=medidasCm[token+1][3];
        respond[24]='c';
        respond[25]='m';
        respond[26]='0';
        respond[27]='0';
        respond[28]='H';
        respond[29]=medidasCm[token+2][0];
        respond[30]=medidasCm[token+2][1];
        respond[31]=medidasCm[token+2][2];
        respond[32]='.';
        respond[33]=medidasCm[token+2][3];
        respond[34]='c';
        respond[35]='m';
        respond[36]='0';
        respond[37]='0';
    }
    if(wUnitsValue=='E') {
        respond[38]='M';
        respond[39]=pesoLb[token][0];
        respond[40]=pesoLb[token][1];
        respond[41]=pesoLb[token][2];
        respond[42]=pesoLb[token][3];
        respond[43]='.';
        respond[44]=pesoLb[token][4];
        respond[45]='l';
        respond[46]='b';
        respond[47]='0';
        respond[48]='0';


    } else {
        respond[38]='M';
        respond[39]=pesoKg[token][0];
        respond[40]=pesoKg[token][1];
        respond[41]=pesoKg[token][2];
        respond[42]=pesoKg[token][3];
        respond[43]='.';
        respond[44]=pesoLb[token][4];
        respond[45]='k';
        respond[46]='g';
        respond[47]='0';
        respond[48]='0';

    }

    respond[49]='0';
    respond[50]='0';
    respond[51]=ETX;
    //respond[52]=CR;
    //respond[53]=LF;
    respond[52]='\0';

    wait_ms(200);

    if(ErrorNum==1) {
        if(token2==0) {
            respond[9]=' ';
            respond[10]=' ';
            respond[11]='0';
            respond[12]='.';
            respond[13]='0';
            if(token3==0) {
                respond[16]='1';
                respond[17]='3';
            } else {
                respond[16]='1';
                respond[17]='2';
            }
        } else if(token2==1) {
            respond[19]=' ';
            respond[20]=' ';
            respond[21]='0';
            respond[22]='.';
            respond[23]='0';
            if(token3==0) {
                respond[26]='1';
                respond[27]='3';
            } else {
                respond[26]='1';
                respond[27]='2';
            }
        } else {
            respond[29]=' ';
            respond[30]=' ';
            respond[31]='0';
            respond[32]='.';
            respond[33]='0';
            if(token3==0) {
                respond[36]='1';
                respond[37]='3';
            } else {
                respond[36]='1';
                respond[37]='2';
            }
        }
    } else if(ErrorNum==2) {
        respond[39]=' ';
        respond[40]=' ';
        respond[41]=' ';
        respond[42]='0';
        respond[43]='.';
        respond[44]='0';
        if(token3==0) {

            respond[47]='1';
            respond[48]='2';
        } else {
            respond[47]='1';
            respond[48]='3';
        }
    }
    pc.printf("%s%s",respond1,respond);
    //printString(respond);
    MeasureNumber++;
}//end measureCom2TS
void itoa(int n, char s[])
{
    int i;
    i=n;
    s[0]=i%10+'0';
    i-=i%10;

    s[1]=(i%100)/10+'0';
    i-=i%100;

    s[2]=(i%1000)/100+'0';
    i-=i%1000;

    s[3]=(i%10000)/1000+'0';

    s[4]='\0';

}

void changeWUnits(void)
{

    if(wUnitsValue=='E') {
        wUnitsValue='M';
        // pc.printf("Weight units set to Metric.\n\r");

    } else {
        wUnitsValue='E';
        //pc.printf("Weight units set to English.\n\r");

    }
}


void changeDUnits(void)
{
    if(dimUnitsValue=='E') {
        dimUnitsValue='M';
        //pc.printf("Dimension units set to Metric.\n\r");

    } else {
        dimUnitsValue='E';
        //pc.printf("Dimension units set to English.\n\r");

    }
}
void ErrorGen(void)
{
    if(ErrorNum<2) {
        ErrorNum++;
    } else {
        ErrorNum=0;
    }
}
