

//#include <string> 

void onBeatDetected();
void CadaSegundo();
void TiempoSample();
bool inicia_sd();
bool setup();
void do_remove(const char *fsrc);
void getOxi();
void getTemp();
bool registraSamples();
bool registraSensores();
void getSample_ECG();
void getSample_RESP();
void getSample_AXIS();
bool write_ECG_file();
bool write_AXIS_file();
void updateSensors ();
void inicia_ble();
void waitEvent();
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params);
void connectionCallback(const Gap::ConnectionCallbackParams_t *params);
void onDataWritten(const GattWriteCallbackParams *params);

// Callback (registered below) fired when a pulse is detected

void onBeatDetected()
{
//   pc.printf("Beat!\r\n");
}

void CadaSegundo() //Aumenta dos contadores cada segundo para registro y actualizacion
{
    RegisterSeconds++;
    UpdateSeconds++;
    if(BLE_TIMEOUT){
        BleSeconds++;
        pc.printf("timeout: %d\r\n",BleSeconds);
        if(BleSeconds == WAIT_CONECTION_TIMEOUT){
            BLE_AVAILABLE = false;
            BLE_TIMEOUT = false;
        }
        
    }
        
}
void TiempoSample() //Timer para samples de Ritmocardiaco,Respiracion y acelerometro
{
    SampleTime = true;
}
bool inicia_sd()
{  
    bool response;
    FILE *fp ;
    
    fp = fopen(PathSensores, "a"); //Intento abrir el archivo... "append"
    if(fp == NULL) {
        pc.printf("No pude abrir el archivo\r\n");
        archivo = false;     //no existe el archivo 
    }
    else
    {
        fprintf(fp, "Dispositivo reiniciado : \r\n"); //Fue un reinicio, solo se logea
        pc.printf("Si existe un archivo\n");
        response = true;
    }
    fclose(fp); 
    
    if (!archivo)
    {
        pc.printf("Creando Carpeta de Logs\r\n");
        mkdir("/sd/LogSensores", 0777);
        fp = fopen(PathSensores, "w");
        if(fp == NULL) 
        {
            pc.printf("No pude abrir el archivo log %s\r\n",PathSensores); 
            response = false;    
        }
        else
        {
            fprintf(fp, "LOG %s creado:\r\n",PathSensores);
            pc.printf("Archivo %s creado por primera vez!\r\n",PathSensores);
            fclose(fp);
            wait(0.2);
            fp = fopen(PathECG, "w");
            
            if(fp == NULL){
                pc.printf("No pude abrir el archivo log %s\r\n",PathECG); 
                response = false; 
            }
            else
            {
                fprintf(fp, "LOG %s creado:\r\n",PathECG);
                pc.printf("Archivo %s creado por primera vez!\r\n",PathECG);
                fclose(fp);
                
                wait(0.2);
                fp = fopen(PathAxis, "w");
                if(fp == NULL){
                    pc.printf("No pude abrir el archivo log %s\r\n",PathAxis);
                    response = false;  
                }
                else
                {
                    fprintf(fp, "LOG %s creado:\r\n",PathAxis);
                    pc.printf("Archivo %s creado por primera vez!\r\n",PathAxis);
                    response = true; 
                } 
            } 
            fclose(fp); 
        } 
        
    }
    return response;
}

bool setup()
{
    
    pc.printf("Start program!\r\n");

    //incializacion SD y archivos de log
    inicia_sd();
    rtcc.begin();
    /* set the time (12:30:00) and date 28/nov/2016 */
   // rtcc.adjust( DateTime( 2016, 10, 28, 12, 30, 0) ); //year,month,day,hour,min, sec,dow


    // Initialize the PulseOximeter instance and register a beat-detected callback
    if(!pox.begin())
        return false;
    pox.setOnBeatDetectedCallback(onBeatDetected);
    return true;
}
void do_remove(const char *fsrc)
{
    DIR *d = opendir(fsrc);
    struct dirent *p;
    char path[30] = {0};
    while((p = readdir(d)) != NULL) {
        strcpy(path, fsrc);
        strcat(path, "/");
        strcat(path, p->d_name);
        remove(path);
    }
    closedir(d);
    remove(fsrc);
}
void getOxi()
{
    heartRate = pox.getHeartRate();
    sp02 = pox.getSpO2();

    if(heartRate != 0 && sp02 != 0) {
        pc.printf("Heart rate: %f",heartRate);
        pc.printf("   bpm / SpO2: %d%\r\n",sp02);
        valuesHeartRate.push_back(heartRate);
        valuesSp02.push_back(sp02);
        counterMAX30100 ++;
    } else {
        pc.printf("Valor Oximetria cero\r\n");
        Oxigeno = 0;
        RitmoCardiaco = 0.00;
        pc.printf("No finger\r\n");
    }
    if(samplesMAX30100 == counterMAX30100) {

        finalHeartRate = 0;
        finalSp02 = 0;
        for(int i=0; i<samplesMAX30100; i++) {
            finalHeartRate += valuesHeartRate[i];
            finalSp02 += valuesSp02[i];
        }

        finalHeartRate /= samplesMAX30100;
        finalSp02 /= samplesMAX30100;

        counterMAX30100 = 0;
        valuesHeartRate.clear();
        valuesSp02.clear();
        newValueMAX30100 = true;
    }

    if(newValueMAX30100) {
        pc.printf("Valor Oximetria valido\r\n");
        newValueMAX30100 = false;
        RitmoCardiaco = finalHeartRate;
        Oxigeno = finalSp02;
    } 
}


void getTemp()
{
    Temperatura = SensorTemp.get();
}


bool registraSamples()
{
    return(true);
}

bool registraSensores()
{
    FILE *fp = fopen("/sd/LogSensores/sensores.txt", "a"); //"a" append
    if(fp == NULL) {
        pc.printf("No pude abrir! :(\r\n");
        return(false);
    } else {
        DateTime time = rtcc.now( );
        fprintf(fp,"T=%.2f,O=%d,RC=%.2f,P=%d,",Temperatura,Oxigeno,RitmoCardiaco,Pasos);
        fprintf(fp,"H=%d:%d:%d,F=%d/%s/%d\r\n",time.hour( ),time.minute( ),time.second( ),
                time.day( ),months[time.month( )],time.year());
        fclose(fp);

        pc.printf("Escribi en SD! :D \r\n");
        pc.printf("T=%.2f,O=%d,RC=%.2f,P=%d,",Temperatura,Oxigeno,RitmoCardiaco,Pasos);
        pc.printf("H=%d:%d:%d,F=%d/%s/%d\r\n",time.hour( ),time.minute( ),time.second( ),
                time.day( ),months[time.month( )],time.year());
        return(true);
    }
}
void getSample_ECG()
{
    if(HR.available())
    {
        ecgSamples[ecg_idx++] = HR.read();
    }
    else
    {
        ecgSamples[ecg_idx++] = 0;
    }
    if(ecg_idx == MUESTRAS_ECG)
    {
        ecg_idx =0;
        ECG_SAMPLE_READY = true;
    }
    
}

void getSample_RESP()
{
    respSamples[resp_idx++] = thermistor.read_u16();
    
    if (resp_idx == MUESTRAS_RESP)
    {
        resp_idx = 0;
        RESP_SAMPLE_READY = true;
    }
}

void getSample_AXIS()
{
    float x, y, z;
    x = abs(acc.getAccX());
    y = abs(acc.getAccY());
    z = abs(acc.getAccZ());
    
    axisSamples[axis_idx][0] = x;
    axisSamples[axis_idx][1] = y;
    axisSamples[axis_idx][2] = z;
    
    axis_idx++;
    
    if (axis_idx == MUESTRAS_AXIS)
    {
        axis_idx = 0;
        AXIS_SAMPLE_READY = true;
    }
}

bool write_ECG_file()
{
   bool response;
    if(true)
    {
        FILE *fp = fopen(PathECG, "a"); //"a" append
        if(fp == NULL) 
        {
            pc.printf("No pude abrir! :(\r\n");
            response =false;
        } 
        else 
        { 
            DateTime time = rtcc.now( );
            fprintf(fp,"%d:%d:%d,%d/%s/%d\r\n",time.hour( ),time.minute( ),time.second( ),
                    time.day( ),months[time.month( )],time.year());
            
            for (int i =0; i< MUESTRAS_ECG; i++)
            {
                fprintf(fp,"%d",ecgSamples[i]);
            }
        
            pc.printf("Escribi en SD! :D \r\n");
            response = true;
            
        }
        fclose(fp);
    }
    return response;
    
}

bool write_AXIS_file()
{
    bool response;
    FILE *fp = fopen(PathAxis, "a"); //"a" append
    if(fp == NULL) 
    {
        pc.printf("No pude abrir! :(\r\n");
        response = false;
    } 
    else 
    { 
        DateTime time = rtcc.now( );
        fprintf(fp,"%d:%d:%d,%d/%s/%d\r\n",time.hour( ),time.minute( ),time.second( ),
                time.day( ),months[time.month( )],time.year());
        
        for (int i =0; i< MUESTRAS_AXIS; i++)
        {  
            fprintf(fp,"%1.2f,%1.2f,%1.2f",axisSamples[0][i],axisSamples[1][i],axisSamples[2][i]);
        }
    
        pc.printf("Escribi en SD! :D \r\n");
        response = true;
    }
    fclose(fp);
    return response;
}



void updateSensors ()
{
    // Make sure to call update as fast as possible
    pox.update();
    
    //<-Get Step Accel

    if(SampleTime){ 
        //cuando se cumpla el tiempo...obtener 1 muestra y aumentar contador
        //getSample ECG
        //getSample Respiracion
        //getSample Axis
        
        getSample_ECG();
        getSample_RESP();
        getSample_AXIS();   
        SampleTime = false;
    }
    if (ECG_SAMPLE_READY)
    {
        ECG_SAMPLE_READY = false;
        write_ECG_file();
        //escribir todas las muestras en SD y borrar contador
    }
    if (AXIS_SAMPLE_READY)
    {
        AXIS_SAMPLE_READY = false;
        write_AXIS_file();
        //escribir todas las muestras en SD y borrar contador
    }
    if (RESP_SAMPLE_READY);
    {
        RESP_SAMPLE_READY = false;
        //Analisis de datos para deteccion de picos
        //escribir todas lasmuestras en SD y borrar contador
    }  
    if (UpdateSeconds >= UPDATE_TIME) { //Si ya paso el tiempo definido en UPDATE_TIME
        getOxi();
        getTemp();
        UpdateSeconds = 0;
    }
    if (RegisterSeconds >= REGISTER_TIME) { //Si ya paso el tiempo definido en REGISTER_TIME

        registraSensores();
        RegisterSeconds = 0;
    }
}




void waitEvent()
{
    if(BLE_DATA_AVAILABLE)
    {
        BLE_DATA_AVAILABLE = false;
        
        switch(datosBle[0])
        {
            case '1':   DEBUG("Recibi 1\r\n");
            {
                break;
            }
            case '2':   DEBUG("Recibi 2\r\n");
            {
                break;
            }
            case '3':   DEBUG("Recibi 3\r\n");
            {
                break;
            }
            case '4':   DEBUG("Recibi 4\r\n");
            {
                break;
            }
        }
        
    }
}



void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    led2=0;
    ble.startAdvertising();
    BLE_AVAILABLE = false;
}
void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    BLE_TIMEOUT = false;
    led2=1;
}


void onDataWritten(const GattWriteCallbackParams *params)
{
    if ((uartServicePtr != NULL) && (params->handle == uartServicePtr->getTXCharacteristicHandle())) {
        uint16_t bytesRead = params->len;
        pc.printf("received %u bytes\r\n", bytesRead);    
        
        for(int i=0;i<bytesRead;i++){
            
            datosBle[i] = params->data[i];
            
        }
        BLE_DATA_AVAILABLE = true;    
    }
}



void inicia_ble()
{
    t1.attach(&CadaSegundo,1);
    t2.attach(&TiempoSample,0.01);
    pc.printf("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)bleName, strlen(bleName));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    UARTService uartService(ble);
    uartServicePtr = &uartService;
    
}



void blink1(int times1, float wait1)
{
    for(int b =0; b< times1; b++)
    {
        led1= 1;
        wait(wait1);
        led1 =0 ;
        wait(wait1);
    }
}
void blink2(int times2, float wait2)
{
    for(int a =0; a< times2; a++)
    {
        led2= 1;
        wait(wait2);
        led2 =0 ;
        wait(wait2);
    }
}

