//////////////////////////////Definiciones BLE

#define WAIT_CONECTION_TIMEOUT 20
const char  *bleName = "BIOMETRICOS";
BLEDevice  ble;
UARTService *uartServicePtr;
bool BLE_DATA_AVAILABLE = false;
bool BLE_AVAILABLE =true;
bool BLE_TIMEOUT = true;
int BleSeconds = 0;
uint8_t datosBle[20];


#define NEED_CONSOLE_OUTPUT 0 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */
#if NEED_CONSOLE_OUTPUT
#define DEBUG(STR) { if (uartServicePtr) uartServicePtr->write(STR, strlen(STR)); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */


///////////////////////////Definiciones para RTC

const char *week[] = {"Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"};//days of the week
const char *months[] = {"ENE","FEB","MAR","ABR","MAY","JUN", "JUL", "AGO","SEP","OCT","NOV","DIC"};//months of the year
I2C device(I2C_SDA,I2C_SCL); //sda scl
Hotboards_rtcc rtcc(device);


//////////////////Variables de sensores para almacenamiento / envio

float       Temperatura;
float       RitmoCardiaco;
uint16_t    Oxigeno;
uint16_t    Pasos;

///////////////////////Definicion para Sensor de temperatura

LM35 SensorTemp(PIN_ADC1); //PIN_ADC

//////////////////////Definicion para Thermistor

AnalogIn thermistor(PIN_ADC2);

///////////////////////////////////////Definicion de SD

SDFileSystem sd(MOSI,MISO,SCLK,CS, "sd"); // // mosi, miso, sclk, cs, name
const char* PathSensores = "/sd/LogSensores/sensores.txt";
const char* PathECG = "/sd/LogSensores/ECG.txt";
const char* PathAxis = "/sd/LogSensores/Axis.txt";
bool archivo = true;


//////////////////////////Definicion de tiempos

#define REGISTER_TIME   30
#define UPDATE_TIME     1
int RegisterSeconds = 0;
int UpdateSeconds = 0;
bool SampleTime = false;
Ticker t1;
Ticker t2;


/////////////////////////Definicion de sensor ECG

#define MUESTRAS_ECG 100
bool ECG_SAMPLE_READY = false;
int ecg_idx = 0;
unsigned short ecgSamples[MUESTRAS_ECG];
float ecgSamples_f[MUESTRAS_ECG];
HeartRate HR(ECG_OUT, ECG_LO_PLS, ECG_LO_MIN);

////////////////////Definicion de sensor RESPIRACION

#define MUESTRAS_RESP 100
bool RESP_SAMPLE_READY = false;
int resp_idx = 0;
unsigned short respSamples[MUESTRAS_RESP];
float respSamples_f[MUESTRAS_RESP];

////////////////////Definicion de muestras ACELEROMETRO
#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q acc(I2C_SDA, I2C_SCL, MMA8451_I2C_ADDRESS);

#define MUESTRAS_AXIS 100
bool AXIS_SAMPLE_READY = false;
int axis_idx = 0;
float axisSamples[MUESTRAS_AXIS][3]; //100 muestras, 3 ejes
//float axisSamples_f[MUESTRAS_axis];


// PulseOximeter is the higher level interface to the sensor
// it offers:
//  * beat detection reporting
//  * heart rate calculation
//  * SpO2 (oxidation level) calculation

///////////////////////////Definiciones  para sensor OXIMETRIA

PulseOximeter pox;

bool newValueMAX30100 = 0;
float heartRate;
float finalHeartRate;
uint8_t sp02;
uint16_t finalSp02;
std::vector<float> valuesHeartRate;
std::vector<uint8_t> valuesSp02;

uint32_t REPORTING_PERIOD_MS = 1000;
uint8_t samplesMAX30100 = 10;
uint8_t counterMAX30100 = 0;;
/////////////////////////////////////////////////////////////////

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut led1(LED_R);
DigitalOut led2(LED_N);
