#include "mbed.h"
#include "EthernetInterface.h"

Serial pc(USBTX, USBRX);

int main() {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    int i = eth.connect();
    pc.printf("Connection = %d, ",i);
    pc.printf("\nIP Address is %s -\nGateway: %s -\nMACAddress %s \n", eth.getIPAddress(),eth.getGateway(),eth.getMACAddress());
    
    TCPSocketConnection sock;
    sock.connect("www.unife.it", 80);
    
    char http_cmd[] = "GET /ing/lm.infoauto HTTP/1.0\n\n";
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    
    char buffer[300];
    int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    
    eth.disconnect();
    
    while(1) {}
}
