/*
University of Leeds
Module: ELEC 2645 - Embedded System Project 
Student: Arthur Guimaraes Yuan
Tilt Sensing
*/

#include "mbed.h"
#include "MMA8452.h"
#include "N5110.h" // LCD

#define PI 3.14159265

Ticker timer;


MMA8452 mma8452(p28,p27);  // SDA, SCL
//Serial serial(USBTX,USBRX);
LocalFileSystem local("local");
BusOut output(p24);

///////////////////////////////////////////////////////////////////////////////////////////
// RTC
Serial serial(USBTX,USBRX);
void serialISR(); // ISR that is called when serial data is received
void setTime(); // function to set the UNIX time
int setTimeFlag = 0; // flag for ISR
char rxString[16]; // buffer to store received string

///////////////////////////////////////////////////////////////////////////////////////////
//LCD
//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd(p7,p8,p9,p10,p11,p13,p21);

//////////////////////////////////////////////////////////////////////////////////////////
// Record Data
void writeDataToFile( float data,float data1,char data2[14], char data3[14]);


//////////////////////////////////////////////////////////////////////////////////////////
// Ticker Timer
int timerFlag = 0;
void timerExpired ()
{
    timerFlag = 1;
}

//////////////////////////////////////////////////////////////////////////////////////////



int main()
{

    lcd.init();
    lcd.turnOn();
    mma8452.init();  // 100 Hz update rate, ±4g scale
    serial.attach(&serialISR);
    Acceleration acceleration;  // Accleration structure declared in MMA8452 class
    timer.attach(&timerExpired,1.0); // Ticker - ISR every 1.0 second

    while(1) {


        // print formatted data to buffer
        char buffer[14];  // each character is 6 pixels, screen is 84 pixels (84/6 = 14)
        char buffer1[14];
        char buffer2[14];
        char buffer3[14];
        char buffer4[14];
        char buffer5[14];


        if(timerFlag) {

            acceleration = mma8452.readValues();   // read current values and print over serial port

            // Get the value from sensor
            float valor1 = acceleration.y;
            float valor2 = acceleration.z;
            float Y = valor1*valor1;
            float Z = valor2*valor2;
            
            //Equantion to get the Roll and Pitch angle, Rotation Rxyz
            // http://cache.freescale.com/files/sensors/doc/app_note/AN3461.pdf?fpsp=1   (pag. 10)
            float V1 = acceleration.y/acceleration.z;
            float Roll = atan(V1)*180/PI;

            float V2 = (-acceleration.x)/(sqrt(Y+Z));
            float Pitch = atan(V2)*180/PI;

            // Store the angles in the buffers
            int b = sprintf(buffer,"Roll=%.2f ",Roll);
            int a = sprintf(buffer1,"Pitch=%.2f",Pitch);


            // Display the results
            lcd.printString(buffer,0,3);
            lcd.printString(buffer1,0,4);

            time_t seconds = time(NULL); // get current time

            // Read the Time and date
            strftime(buffer2, 30 , "%X", localtime(&seconds));
            strftime(buffer3, 30 , "%D", localtime(&seconds));
            
            // format time into a string (time and date)
            sprintf(buffer4,"Time:%s",buffer2);
            sprintf(buffer5,"%s",buffer3);

            // Display time and date
            lcd.printString(buffer4,0,1);       // display on screen
            lcd.printString(buffer5,0,0);

            // Set the angle to turn on the LED
            if (Roll > 30 | Roll < -30 | Pitch > 30 | Pitch < -30) {
                output = 1;

            }

            else {
                output = 0;
            }

            writeDataToFile(Roll,Pitch,buffer4,buffer5);
            timerFlag = 0;
        }


    }

}





//---Functions----------------------------------------------------------------------------------------------//

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Real Time Clock
void setTime()
{
// print time for debugging
    serial.printf("set_time - %s",rxString);
// atoi() converts a string to an integer
    int time = atoi(rxString);
// update the time
    set_time(time);
}
void serialISR()
{
// when a serial interrupt occurs, read rx string into buffer
    serial.gets(rxString,16);
// set flag
    setTimeFlag = 1;
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Writing Files
void writeDataToFile( float data,float data1,char data2[14], char data3[14])
{
    //led2 = 1; // turn on LEDs for feedback
    FILE *fp = fopen("/local/data.txt", "a"); // open 'log.txt' for appending
// if the file doesn't exist it is created, if it exists, data is appended to the end
    fprintf(fp,"Data: %s %s, Roll %.2f  Pitch %.2f \n",data2,data3,data,data1); // print string to file
    fclose(fp); // close file
    //leds = 0; // turn off LEDs to signify file access has finished
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////