#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"
#include "C12832.h"

C12832 lcd(D11, D13, D12, D7, D10);
DigitalOut led(LED1);

int main()
{
    printf("Server example\n\r");
    
    EthernetInterface eth;
    eth.set_network("192.168.0.19","255.255.255.0","192.168.0.1");
    eth.connect();
    
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    
    TCPServer srv(&eth);  
    
    srv.bind(4000);
    
    srv.listen();
    
    while(true){
        TCPSocket client;
        SocketAddress client_addr;
        char *buffer = "Hello TCP client!\r\n";
        
        srv.accept(&client, &client_addr);
        
        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(), 
                    client_addr.get_port());
                    
        client.send(buffer, 256);
        
        char data[3];
        client.recv(data, sizeof data);
        float temp = float(((data[0]<<8)|data[1]) / 256.0);
        int pwm = (int)data[2];
        printf("The temperature is: %f\r\n", temp);
        printf("The PWM value is: %x\r\n", data[2]);
        
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp = %.1f\n", temp);
    
        client.close();
        
    }
}
