#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832.h"
#include "LM75B.h"
// Using Arduino pin notation
C12832 lcd(D11, D13, D12, D7, D10);
DigitalOut led(LED1);
LM75B sensor(D14,D15);

int main()
{
    lcd.printf("PeerToPeer\n\r");
    lcd.printf("Temp = %.1f\n", sensor.read());
    EthernetInterface eth;
    eth.set_network("192.168.0.07","255.255.255.0","192.168.0.1");
    eth.connect();

    printf("The client IP address is '%s'\n\r", eth.get_ip_address());


    TCPSocket socket;

    socket.open(&eth);
    socket.connect("192.168.0.19",4000);
    
    uint16_t temp = sensor.read();
    char upperbyte =(temp>>8) & 0xFF;
    char lowerbyte = temp & 0xFF;
    char data[2] = {upperbyte, lowerbyte};
    printf("The data is: %c\n", data[0]);
    socket.send(data,2);
    socket.close();

}


