#ifndef HPP__UTILS_SYSTEM
#define HPP__UTILS_SYSTEM

#include "utils/buffer.hpp"
#include "utils/math.hpp"
#include "mbed.h"
namespace Utils {
    /// @namespace Utils::System
    /// Espace de nom reservé au modelisation de systeme dynamique.
    namespace System {

        /// @class Utils::System::System
        /// Classe mere de toute les classes permetant de modeliser des systemes dynamique.
        /// Permet de ranger tout les outils de modelisation de systeme.
        class System {
        public:
            /// Faire avancer l'etat du systeme d'une etape.
            virtual float step (float) = 0;
            virtual float read () const = 0;
        };

        /// @class Utils::System::Default
        /// Systeme par defaut. Equivalant à un suiveur, H = 1.
        class Default: public System {
        protected:
            float _in;
        public:
            virtual float step (float);
            virtual float read () const;
        };

        /// @class Utils::System::Z
        /// Classe permetant de modeliser un systeme en Z.
        class Z: public System {
        protected:
            Utils::Buffer::Circular<float> _in;  ///< Valeurs en entrées.
            Utils::Buffer::Circular<float> _out; ///< Valeurs en sorties.
            float freq; ///< Frequence d'echantillonnage du systeme.
        public:
            Utils::Buffer::Buffer<float>&  _p;   ///< Liste des coefficents du numerateur du modele en Z.
            Utils::Buffer::Buffer<float>&  _q;   ///< Liste des coefficients du denominateur du modele en Z.
            Z ( Buffer::Buffer<float>&, Buffer::Buffer<float>& );
            Z ( const size_t, const size_t );

            virtual float step (float);
            virtual float read () const;
        };

        /// @class Utils::System::P
        /// Classe permetant de modeliser un systeme en p.
        class P: public Z {
        protected:
            /* ... */
        public:
            P (
                Buffer::Buffer<float>&, Buffer::Buffer<float>&,
                float
            );
            virtual float step (float);
            virtual float read () const;
        };

    }
}

#endif
