#include "utils/system.hpp"

using namespace Utils::System;

/// Renvoit la valeur entrée.
/// @param  in Valeur en entrée.
/// @return Renvoit la valeur en entrée.
float Default::step ( float in ) {
    return _in = in;
}
//-----------------------------------------------------------------------------
/// Lire la valeur en sortie du systeme (ici la sortie correspond à l'entrée).
/// @return Valeur de la sortie.
float Default::read () const {
    return _in;
}

//-----------------------------------------------------------------------------
P::P ( Buffer::Buffer<float> &p, Buffer::Buffer<float> &q, float dt )
: Z(p.length(), q.length()) {
    float t = 1;
    for(size_t i=0 ; i<p.length() ; ++i )
        for( size_t k=0 ; k<=i ; ++k, t*=dt )
            Z::_p[k]+= p[i] * Math::combination(i,k) / t * (k%2 ?-1 : 1);
    
    t = 1;
    for(size_t i=0 ; i<q.length() ; ++i )
        for( size_t k=0 ; k<=i ; ++k, t*=dt  )
            Z::_q[k]+= q[i] * Math::combination(i,k) / t * (k%2 ?-1 : 1);
}
//-----------------------------------------------------------------------------
float P::step ( float in ) {
    return Z::step(in);
}
//-----------------------------------------------------------------------------
/// @attention Non implementé.
float P::read () const {
    return Z::read();
}

//-----------------------------------------------------------------------------
Z::Z ( Buffer::Buffer<float> &p, Buffer::Buffer<float> &q )
: _in(p.length()), _out(q.length()), _p(p), _q(q) {
    _in .set(0.0); _out.set(0.0);
}
//-----------------------------------------------------------------------------
Z::Z ( const size_t size_p, const size_t size_q )
: _in(size_p), _out(size_q),
_p(*new Buffer::Buffer<float>(size_p)), _q(*new Buffer::Buffer<float>(size_q)) {
    _in .set(0.0); _out.set(0.0);
    _p  .set(0.0); _q  .set(0.0);
}
//-----------------------------------------------------------------------------
/// Calcul la valeur suivante de la suite numerique represantant le systeme en Z.
/// @param in  Valeur de l'entrée pour l'etape actuelle.
/// @return    Valeur de la sortie pour l'etape actuelle.
float Z::step( float in ) {
    float out=0;
    _in  << 1; // shift
    _out << 1; //

    _in[0] = in;

    for( size_t i=0 ; i<_p.length() ; i++ )
        out += _in [i] * _p[i];

    for( size_t i=1 ; i<_q.length() ; i++ )
        out -= _out[i] * _q[i];

    out /= _q[0];

    _out[0] = out;

    return out;
}
//-----------------------------------------------------------------------------
/// @return Valeur de sortie pour l'etape actuelle.
float Z::read () const {
    return this->_in[0];
}