#ifndef HPP__UTILS_POSITION
#define HPP__UTILS_POSITION

#include "utils/speed.hpp"
#include "mbed.h"

/// @namespace Utils
namespace Utils {
    
    /// @class Utils::Position
    /// Outils de calcul de position du robot dans un plan.
    class Position {
    public:
        Position () : x(0), y(0), theta(0) {};
        Position (float x, float y) : x(x), y(y), theta(0) {};
        Position (float x, float y, float a) : x(x), y(y), theta(a) {};
        Position (const Position& pos): x(pos.x), y(pos.y), theta(pos.theta) {};
        ~Position() {};
        
        Position& operator+  ( Position& );
        Position& operator-  ( Position& );
        Position& operator+= ( Position& );
        Position& operator-= ( Position& );
        Position& operator*= ( float );
        Position& operator/= ( float );
        Position& operator-  ();
        
        Position& add_speed ( Speed v, float f );
        
        float x;     ///< Position X. [m]
        float y;     ///< Position Y. [m]
        float theta; ///< Orientation (sens trigo). [rad]
    };

}

#endif
