#include "utils/position.hpp"

using namespace Utils;

Position& Position :: operator+ ( Position &p ) {
    return *new Position(
        x     + p.x,
        y     + p.y,
        theta + p.theta
    );
}

//-----------------------------------------------------------------------------
Position& Position :: operator- ( Position &p ) {
    return *new Position(
        x     - p.x,
        y     - p.y,
        theta - p.theta
    );
}

//-----------------------------------------------------------------------------
Position& Position :: operator+= ( Position &p ) {
    x     += p.x;
    y     += p.y;
    theta += p.theta;
    return *this;
}

//-----------------------------------------------------------------------------
Position& Position :: operator-= ( Position &p ) {
    x     -= p.x;
    y     -= p.y;
    theta -= p.theta;
    return *this;
}

//-----------------------------------------------------------------------------
Position& Position :: operator- ( ) {
    return *new Position( -x, -y, -theta );
}

//-----------------------------------------------------------------------------
Position& Position :: operator*= ( float a ) {
    x *= a;
    y *= a;
    return *this;
}

//-----------------------------------------------------------------------------
Position& Position :: operator/= ( float a ) {
    x /= a;
    y /= a;
    return *this;
}

//-----------------------------------------------------------------------------
Position& Position :: add_speed ( Speed v, float f ) {
    x     += cos( v.w/f/2 + theta ) * v.v;
    y     += sin( v.w/f/2 + theta ) * v.v;
    theta += v.w/f;
    return *this;
}
