#ifndef HPP__ROBOT_SENSOR
#define HPP__ROBOT_SENSOR
    
    /// @namespace Robot
    namespace Robot {
        /// @namespace Robot::Sensor
        /// Espace de nom reservé au capteur du robot.
        namespace Sensor {
            
            /// @class Robot::Sensor::Sensor
            /// Classe permetant de definir un capteur quelconque. (classe abstraite)
            class Sensor {
            public:
                /// Permet de lire la mesure du capteur. (fonction virtuelle pure)
                /// @return Doit renvoyer la mesure du capteur.
                virtual float read() = 0;
            };
            
            /// @class Robot::Sensor::Default
            /// Capteur par defaut (Ne mesure rien et renvoit toujours 0).
            class Default: public Sensor {
            public:
                /// Lire la mesure du capteur (ici la valeur est de 0).
                /// @return Renvoit 0.
                virtual float read ( ) { return 0; }
            };
            
        }
    }
    
    // Inclure les fichiers header qui utilise la class Robot::Sensor::Sensor.
    #include "robot/sensor/encoder.hpp"
    #include "robot/sensor/analog.hpp"
    
#endif
