#ifndef HPP__ROBOT_SENSOR_ENCODER
#define HPP__ROBOT_SENSOR_ENCODER

#include "robot/sensor/sensor.hpp"
#include "mbed.h"

/// @namespace Robot
namespace Robot {
    /// @namespace Robot::Sensor
    namespace Sensor {

        /// @class Robot::Sensor::Encoder
        /// Definition de la classe Encoder qui permet de manipuler des encodeurs 2 voies en quadrature.
        /// 
        /// @b Exemple:
        /// @code
        /// #include "robot/sensor/encode.hpp"
        /// #include "mbed.h"
        ///
        /// int main ( ) {
        ///     Robot::Sensor::Encoder encoder( PIN1, PIN2, 1024 );
        ///     int count = 0;
        ///     encoder.reset();
        ///     
        ///     while (1) {
        ///         count += encoder.read(); // Lire la valeur de compatage depuis la derniere lecture.
        ///         printf("count : %d\n", count); // Envoier sur le port serie.
        ///         wait(0.5f); // faire une pause.
        ///     }
        /// }
        /// @endcode
        /// 
        /// @author  VIANES Arthur
        /// @date    2016-01-07
        class Encoder: public Sensor {
        public:
            // Contructeur
            Encoder (PinName, PinName, float);
            // Fonctions
            virtual float read ();
            void  reset ();
        protected:
            // Fonctions interne
            void chA_fall ();
            void chA_rise ();
            void chB_fall ();
            void chB_rise ();
            
            volatile int _count;  ///< Valeur de comptage.
            InterruptIn  _chA;    ///< Broche A.
            InterruptIn  _chB;    ///< Broche B.
            float        _points; ///< Nombre de point par tours.
        };
    
    } 
}

#endif
